/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.event.component;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import junit.framework.Assert;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.annotation.binding.Check;
import org.apache.webbeans.test.annotation.binding.NotAnyLiteral;
import org.apache.webbeans.test.annotation.binding.Role;
import org.apache.webbeans.test.component.CheckWithCheckPayment;
import org.apache.webbeans.test.component.CheckWithMoneyPayment;
import org.apache.webbeans.test.component.PaymentProcessorComponent;
import org.apache.webbeans.test.component.event.normal.ComponentWithObservable1;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves1;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves2;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves3;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves4;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves5;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves6;
import org.apache.webbeans.test.component.event.normal.TransactionalInterceptor;
import org.apache.webbeans.test.event.LoggedInEvent;
import org.apache.webbeans.util.WebBeansUtil;
import org.junit.Before;
import org.junit.Test;

public class ObserversComponentTest
extends TestContext {
    public ObserversComponentTest() {
        super(ObserversComponentTest.class.getName());
    }

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Test
    public void testObserves() {
        this.clear();
        AbstractInjectionTargetBean<ComponentWithObserves1> component = this.defineManagedBean(ComponentWithObserves1.class);
        ContextFactory.initRequestContext(null);
        LoggedInEvent event = new LoggedInEvent("Gurkan");
        Annotation[] anns = new Annotation[]{new AnyLiteral()};
        this.getManager().fireEvent(event, anns);
        ComponentWithObserves1 instance = this.getManager().getInstance(component);
        Assert.assertEquals((String)"Gurkan", (String)instance.getUserName());
    }

    @Test
    public void testWithObservable() {
        this.clear();
        this.getManager().addBean((Bean<?>)WebBeansUtil.getEventBean());
        AbstractInjectionTargetBean<ComponentWithObserves1> component = this.defineManagedBean(ComponentWithObserves1.class);
        AbstractInjectionTargetBean<ComponentWithObservable1> componentObservable = this.defineManagedBean(ComponentWithObservable1.class);
        ContextFactory.initRequestContext(null);
        ComponentWithObserves1 instance = this.getManager().getInstance(component);
        ComponentWithObservable1 observable = this.getManager().getInstance(componentObservable);
        observable.afterLoggedIn();
        Assert.assertEquals((String)"Gurkan", (String)instance.getUserName());
    }

    @Test
    public void testObservesIfExists() {
        this.clear();
        this.getManager().addBean((Bean<?>)WebBeansUtil.getEventBean());
        AbstractInjectionTargetBean<ComponentWithObserves3> component3 = this.defineManagedBean(ComponentWithObserves3.class);
        AbstractInjectionTargetBean<ComponentWithObserves4> component4 = this.defineManagedBean(ComponentWithObserves4.class);
        AbstractInjectionTargetBean<ComponentWithObserves5> component5 = this.defineManagedBean(ComponentWithObserves5.class);
        AbstractInjectionTargetBean<ComponentWithObserves6> component6 = this.defineManagedBean(ComponentWithObserves6.class);
        ContextFactory.initRequestContext(null);
        ComponentWithObserves4 instance = this.getManager().getInstance(component4);
        ComponentWithObserves5 instanceIE = this.getManager().getInstance(component5);
        ComponentWithObserves6 outstance = this.getManager().getInstance(component6);
        instanceIE.getUserName();
        LoggedInEvent event = new LoggedInEvent("Gurkan");
        Annotation[] anns = new Annotation[]{new NotAnyLiteral()};
        this.getManager().fireEvent(event, anns);
        Assert.assertEquals((String)"IEGurkan", (String)outstance.getUserIEName());
        Assert.assertEquals((String)"Gurkan", (String)outstance.getUserName());
        Assert.assertNull((Object)outstance.getUserNIEName());
    }

    @Test
    public void testObservesWithBindingMember() {
        this.clear();
        this.getManager().addBean((Bean<?>)WebBeansUtil.getEventBean());
        AbstractInjectionTargetBean<ComponentWithObserves1> component = this.defineManagedBean(ComponentWithObserves1.class);
        ContextFactory.initRequestContext(null);
        LoggedInEvent event = new LoggedInEvent("Gurkan");
        class CheckLiteral
        extends AnnotationLiteral<Check>
        implements Check {
            CheckLiteral() {
            }

            @Override
            public String type() {
                return "CHECK";
            }
        }
        Annotation[] anns = new Annotation[]{new CheckLiteral()};
        this.getManager().fireEvent(event, anns);
        ComponentWithObserves1 instance = this.getManager().getInstance(component);
        Assert.assertNotNull((Object)instance.getUserName());
        Assert.assertEquals((String)"Gurkan", (String)instance.getUserNameWithMember());
    }

    @Test
    public void testFireWithAtAnyQualifier() {
        this.clear();
        this.getManager().addBean((Bean<?>)WebBeansUtil.getEventBean());
        AbstractInjectionTargetBean<ComponentWithObserves1> component = this.defineManagedBean(ComponentWithObserves1.class);
        ContextFactory.initRequestContext(null);
        LoggedInEvent event = new LoggedInEvent("Mark");
        Annotation[] anns = new Annotation[]{new AnyLiteral()};
        this.getManager().fireEvent(event, anns);
        ComponentWithObserves1 instance = this.getManager().getInstance(component);
        Assert.assertEquals((String)"Mark", (String)instance.getUserName());
        Assert.assertNull((Object)instance.getUserNameWithMember());
    }

    @Test
    public void testObservesWithBindingMember2() {
        this.clear();
        this.defineInterceptor(TransactionalInterceptor.class);
        this.defineManagedBean(CheckWithCheckPayment.class);
        this.defineManagedBean(CheckWithMoneyPayment.class);
        this.defineManagedBean(PaymentProcessorComponent.class);
        AbstractInjectionTargetBean<ComponentWithObserves2> component = this.defineManagedBean(ComponentWithObserves2.class);
        ContextFactory.initRequestContext(null);
        LoggedInEvent event = new LoggedInEvent("USER");
        ComponentWithObserves2.hasBeenIntercepted = false;
        class RoleUser
        extends AnnotationLiteral<Role>
        implements Role {
            RoleUser() {
            }

            @Override
            public String value() {
                return "USER";
            }
        }
        Annotation[] anns = new Annotation[]{new RoleUser()};
        this.getManager().fireEvent(event, anns);
        ComponentWithObserves2 instance = this.getManager().getInstance(component);
        Assert.assertFalse((boolean)ComponentWithObserves2.hasBeenIntercepted);
        Assert.assertNotNull((Object)instance.getPayment());
        Assert.assertEquals((String)"USER", (String)instance.getUser());
        class RoleAdmin
        extends AnnotationLiteral<Role>
        implements Role {
            RoleAdmin() {
            }

            @Override
            public String value() {
                return "ADMIN";
            }
        }
        anns[0] = new RoleAdmin();
        event = new LoggedInEvent("ADMIN");
        this.getManager().fireEvent(event, anns);
        instance = this.getManager().getInstance(component);
        Assert.assertTrue((boolean)ComponentWithObserves2.hasBeenIntercepted);
        Assert.assertNotNull((Object)instance.getPayment());
        Assert.assertEquals((String)"ADMIN", (String)instance.getUser());
        ComponentWithObserves2.hasBeenIntercepted = false;
        this.getManager().fireEvent(event, anns);
        instance = this.getManager().getInstance(component);
        Assert.assertTrue((boolean)ComponentWithObserves2.hasBeenIntercepted);
        Assert.assertNotNull((Object)instance.getPayment());
        Assert.assertEquals((String)"ADMIN", (String)instance.getUser());
    }
}

