/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.dependent;

import java.util.List;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.component.dependent.DependentComponent;
import org.apache.webbeans.test.component.dependent.DependentOwnerComponent;
import org.apache.webbeans.test.component.dependent.circular.DependentA;
import org.apache.webbeans.test.component.dependent.circular.DependentB;
import org.junit.Before;
import org.junit.Test;

public class DependentComponentTest
extends TestContext {
    public DependentComponentTest() {
        super(DependentComponentTest.class.getName());
    }

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Test
    public void testDependent() {
        this.clear();
        this.defineManagedBean(DependentComponent.class);
        this.defineManagedBean(DependentOwnerComponent.class);
        ContextFactory.initRequestContext(null);
        List<AbstractOwbBean<?>> comps = this.getComponents();
        Assert.assertEquals((int)2, (int)comps.size());
        DependentOwnerComponent comp = (DependentOwnerComponent)this.getManager().getInstance((Bean)comps.get(1));
        DependentComponent dc = comp.getDependent();
        Assert.assertNotNull((Object)dc);
        ContextFactory.destroyRequestContext(null);
    }

    @Test
    public void testDependentCircular() {
        this.clear();
        ContextFactory.initRequestContext(null);
        AbstractInjectionTargetBean<DependentA> componentA = this.defineManagedBean(DependentA.class);
        AbstractInjectionTargetBean<DependentB> componentB = this.defineManagedBean(DependentB.class);
        Assert.assertNotNull(componentB);
        DependentA dependentA = this.getManager().getInstance(componentA);
        Assert.assertNotNull((Object)dependentA);
        Assert.assertNotNull((Object)dependentA.getDependentB());
    }
}

