/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.unittests.annotation;

import org.apache.webbeans.annotation.WebBeansAnnotation;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.annotation.binding.AnnotationWithBindingMember;
import org.apache.webbeans.test.unittests.annotation.AnnotatedClass;
import org.apache.webbeans.test.unittests.annotation.DefaultAnnotatedClass;
import org.apache.webbeans.test.unittests.annotation.LiteralType;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationTest
extends TestContext {
    public AnnotationTest() {
        super(AnnotationTest.class.getName());
    }

    @Test
    public void testAnnotationLiteral() {
        AnnotationWithBindingMember annotation = AnnotatedClass.class.getAnnotation(AnnotationWithBindingMember.class);
        WebBeansAnnotation webBeansAnnotation = new WebBeansAnnotation(AnnotationWithBindingMember.class);
        LiteralType al = new LiteralType(){

            @Override
            public int number() {
                return 5;
            }

            @Override
            public String value() {
                return "Gurkan";
            }
        };
        webBeansAnnotation.setMemberValue("value", (Object)"Gurkan");
        webBeansAnnotation.setMemberValue("number", (Object)5);
        Assert.assertTrue((boolean)annotation.equals(al));
    }

    @Test
    public void testAnnotationWebBeans() {
        AnnotationWithBindingMember annotation = AnnotatedClass.class.getAnnotation(AnnotationWithBindingMember.class);
        AnnotationWithBindingMember defAnnotation = DefaultAnnotatedClass.class.getAnnotation(AnnotationWithBindingMember.class);
        WebBeansAnnotation webBeansAnnotation = JavassistProxyFactory.createNewAnnotationProxy(AnnotationWithBindingMember.class);
        webBeansAnnotation.setMemberValue("value", (Object)"Gurkan");
        webBeansAnnotation.setMemberValue("number", (Object)5);
        Assert.assertTrue((boolean)annotation.equals(webBeansAnnotation));
        Assert.assertTrue((boolean)webBeansAnnotation.equals((Object)annotation));
        WebBeansAnnotation webBeansAnnotation2 = JavassistProxyFactory.createNewAnnotationProxy(AnnotationWithBindingMember.class);
        Assert.assertTrue((boolean)webBeansAnnotation2.equals((Object)defAnnotation));
        Assert.assertTrue((boolean)defAnnotation.equals(webBeansAnnotation2));
        Assert.assertTrue((!webBeansAnnotation2.equals((Object)annotation) ? 1 : 0) != 0);
        Assert.assertTrue((!annotation.equals(webBeansAnnotation2) ? 1 : 0) != 0);
    }
}

