/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test.containertests;

import java.util.Set;
import junit.framework.Assert;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.test.TestContext;
import org.apache.webbeans.test.annotation.binding.AnnotationWithBindingMember;
import org.apache.webbeans.test.annotation.binding.AnnotationWithNonBindingMember;
import org.apache.webbeans.test.component.BindingComponent;
import org.apache.webbeans.test.component.NonBindingComponent;
import org.junit.Before;
import org.junit.Test;

public class ComponentResolutionByTypeTest
extends TestContext {
    @AnnotationWithBindingMember(value="B", number=3)
    public BindingComponent s1 = null;
    @AnnotationWithBindingMember(value="B")
    public BindingComponent s2 = null;
    @AnnotationWithNonBindingMember(value="B", arg1="arg1", arg2="arg2")
    public NonBindingComponent s3 = null;
    @AnnotationWithNonBindingMember(value="B", arg1="arg11", arg2="arg21")
    public NonBindingComponent s4 = null;
    @AnnotationWithNonBindingMember(value="C", arg1="arg11", arg2="arg21")
    public NonBindingComponent s5 = null;
    private BeanManagerImpl cont;
    private static final String CLAZZ_NAME = ComponentResolutionByTypeTest.class.getName();

    public ComponentResolutionByTypeTest() {
        super(CLAZZ_NAME);
    }

    @Override
    @Before
    public void init() {
        this.cont = BeanManagerImpl.getManager();
    }

    @Test
    public void testBindingTypeOk() throws Throwable {
        this.cont.resolveByType(BindingComponent.class, ComponentResolutionByTypeTest.class.getDeclaredField("s1").getAnnotations());
    }

    @Test
    public void testBindingTypeNonOk() throws Throwable {
        this.cont.resolveByType(BindingComponent.class, ComponentResolutionByTypeTest.class.getDeclaredField("s2").getAnnotations());
    }

    @Test
    public void testNonBindingTypeOk1() throws Throwable {
        this.cont.resolveByType(NonBindingComponent.class, ComponentResolutionByTypeTest.class.getDeclaredField("s3").getAnnotations());
    }

    @Test
    public void testNonBindingTypeOk2() throws Throwable {
        Set beans = this.cont.resolveByType(NonBindingComponent.class, ComponentResolutionByTypeTest.class.getDeclaredField("s4").getAnnotations());
        Assert.assertNotNull((Object)beans);
        Assert.assertTrue((boolean)beans.isEmpty());
    }

    @Test
    public void testNonBindingTypeNonOk() throws Throwable {
        this.cont.resolveByType(NonBindingComponent.class, ComponentResolutionByTypeTest.class.getDeclaredField("s5").getAnnotations());
    }
}

