/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.test;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.interceptor.Interceptor;
import junit.framework.Assert;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.xml.XMLManagedBean;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.ManagedBeanConfigurator;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.decorator.DecoratorUtil;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.deployment.stereotype.IStereoTypeModel;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.intercept.WebBeansInterceptorConfig;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.test.component.decorator.broken.DelegateAttributeIsnotInterface;
import org.apache.webbeans.test.component.decorator.broken.DelegateAttributeMustImplementAllDecoratedTypes;
import org.apache.webbeans.test.component.decorator.broken.MoreThanOneDelegateAttribute;
import org.apache.webbeans.test.component.decorator.broken.PaymentDecorator;
import org.apache.webbeans.test.component.decorator.clean.LargeTransactionDecorator;
import org.apache.webbeans.test.component.decorator.clean.ServiceDecorator;
import org.apache.webbeans.test.component.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.test.component.intercept.webbeans.WebBeanswithMetaInterceptor;
import org.apache.webbeans.test.mock.MockManager;
import org.apache.webbeans.test.servlet.ITestContext;
import org.apache.webbeans.test.sterotype.StereoWithNonScope;
import org.apache.webbeans.test.sterotype.StereoWithRequestScope;
import org.apache.webbeans.test.sterotype.StereoWithSessionScope;
import org.apache.webbeans.test.sterotype.StereoWithSessionScope2;
import org.apache.webbeans.test.unittests.xml.XMLTest;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;
import org.apache.webbeans.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TestContext
implements ITestContext {
    private WebBeansLogger logger = WebBeansLogger.getLogger(TestContext.class);
    private static Set<ITestContext> testContexts = new HashSet<ITestContext>();
    private String clazzName;
    private MockManager manager;
    protected WebBeansXMLConfigurator xmlConfigurator = null;

    protected TestContext(String clazzName) {
        this.clazzName = clazzName;
        testContexts.add(this);
        this.manager = new MockManager();
        this.xmlConfigurator = new WebBeansXMLConfigurator();
        PluginLoader.getInstance().startUp();
    }

    @Override
    public void init() {
        this.manager.clear();
        PluginLoader.getInstance().startUp();
        this.initInterceptors();
        this.initDecorators();
        this.initStereoTypes();
        this.initDependentContext();
    }

    protected void initDependentContext() {
        DependentContext dependentContext = (DependentContext)ContextFactory.getStandardContext(Dependent.class);
        dependentContext.setActive(true);
    }

    protected void initInterceptors() {
        this.initializeInterceptorType(WebBeansInterceptor.class);
        this.initializeInterceptorType(WebBeanswithMetaInterceptor.class);
    }

    protected void initDecorators() {
        this.initializeDecoratorType(DelegateAttributeIsnotInterface.class);
        this.initializeDecoratorType(MoreThanOneDelegateAttribute.class);
        this.initializeDecoratorType(PaymentDecorator.class);
        this.initializeDecoratorType(DelegateAttributeMustImplementAllDecoratedTypes.class);
        this.initializeDecoratorType(ServiceDecorator.class);
        this.initializeDecoratorType(LargeTransactionDecorator.class);
    }

    protected void initStereoTypes() {
        this.initDefaultStereoTypes();
        this.initializeStereoType(StereoWithNonScope.class);
        this.initializeStereoType(StereoWithRequestScope.class);
        this.initializeStereoType(StereoWithSessionScope.class);
        this.initializeStereoType(StereoWithSessionScope2.class);
    }

    protected void addInstanceImplicitBean(Bean<?> bean) {
        Set injectionPoints = bean.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (!injectionPoint.getAnnotated().getBaseType().equals(Instance.class)) continue;
        }
    }

    protected void initDefaultStereoTypes() {
        this.initializeStereoType(Interceptor.class);
        this.initializeStereoType(Decorator.class);
    }

    protected void beforeTest() {
    }

    public void fail(String methodName) {
        this.logger.error("Test Class: " + this.clazzName + ",Method Name: " + methodName + " is FAILED");
    }

    public void pass(String methodName) {
        this.logger.info("Test Class: " + this.clazzName + ",Method Name: " + methodName + " is PASSED");
    }

    public static void initTests() {
        Iterator<ITestContext> it = testContexts.iterator();
        while (it.hasNext()) {
            it.next().init();
        }
    }

    public static void startAllTests(Object object) {
        Iterator<ITestContext> it = testContexts.iterator();
        while (it.hasNext()) {
            it.next().startTests(object);
        }
    }

    public static void endAllTests(Object object) {
        Iterator<ITestContext> it = testContexts.iterator();
        while (it.hasNext()) {
            it.next().endTests(object);
        }
    }

    protected <T> AbstractInjectionTargetBean<T> defineManagedBean(Class<T> clazz) {
        ManagedBean bean = null;
        bean = ManagedBeanConfigurator.define(clazz, (WebBeansType)WebBeansType.MANAGED);
        if (bean != null) {
            this.manager.addBean((Bean<?>)WebBeansUtil.createNewBean((AbstractInjectionTargetBean)bean));
            DecoratorUtil.checkManagedBeanDecoratorConditions((AbstractInjectionTargetBean)bean, null);
            WebBeansDecoratorConfig.configureDecarotors((AbstractInjectionTargetBean)bean);
            DefinitionUtil.defineBeanInterceptorStack((AbstractInjectionTargetBean)bean);
            this.getComponents().add((AbstractOwbBean<?>)bean);
            this.manager.addBean((Bean<?>)bean);
            GProcessAnnotatedType type = new GProcessAnnotatedType(AnnotatedElementFactory.getInstance().newAnnotatedType(clazz));
            this.manager.fireEvent(type, new Annotation[0]);
        }
        return bean;
    }

    protected <T> XMLManagedBean<T> defineXMLSimpleWebBeans(Class<T> simpleClass, Element webBeanDecleration) {
        XMLManagedBean bean = null;
        bean = this.xmlConfigurator.configureSimpleWebBean(simpleClass, webBeanDecleration);
        return bean;
    }

    protected XMLManagedBean<?> getWebBeanFromXml(String xmlResourcePath) {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream(xmlResourcePath);
        Assert.assertNotNull((Object)stream);
        Element beanElement = null;
        Element rootElement = XMLUtil.getRootElement((InputStream)stream);
        NodeList ns = rootElement.getChildNodes();
        for (int i = 0; i <= ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            beanElement = (Element)node;
            break;
        }
        Class clazz = XMLUtil.getElementJavaType(beanElement);
        XMLManagedBean def = this.defineXMLSimpleWebBeans(clazz, beanElement);
        return def;
    }

    protected AbstractOwbBean<?> getWebBeanFromXml(String xmlResourcePath, Class<?> desiredClazz, Annotation ... bindings) {
        InputStream stream = XMLTest.class.getClassLoader().getResourceAsStream(xmlResourcePath);
        Assert.assertNotNull((Object)stream);
        Element rootElement = XMLUtil.getRootElement((InputStream)stream);
        NodeList nodes = rootElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element beanElement = (Element)node;
            Class clazz = XMLUtil.getElementJavaType((Element)beanElement);
            this.defineXMLSimpleWebBeans(clazz, beanElement);
        }
        Set<Bean<?>> beans = this.getManager().getBeans(desiredClazz, bindings);
        if (beans != null && beans.size() == 1) {
            return (AbstractOwbBean)beans.iterator().next();
        }
        return null;
    }

    protected <T> AbstractOwbBean<T> defineInterceptor(Class<T> clazz) {
        ManagedBean component = null;
        ManagedBeanConfigurator.checkManagedBeanCondition(clazz);
        InterceptorsManager.getInstance().addNewInterceptor(clazz);
        InterceptorUtil.checkInterceptorConditions(clazz);
        component = ManagedBeanConfigurator.define(clazz, (WebBeansType)WebBeansType.INTERCEPTOR);
        WebBeansInterceptorConfig.configureInterceptorClass((AbstractInjectionTargetBean)component, (Annotation[])AnnotationUtil.getInterceptorBindingMetaAnnotations((Annotation[])clazz.getDeclaredAnnotations()));
        return component;
    }

    protected <T> AbstractOwbBean<T> defineDecorator(Class<T> clazz) {
        ManagedBean component = null;
        if (DecoratorsManager.getInstance().isDecoratorEnabled(clazz)) {
            DecoratorUtil.checkDecoratorConditions(clazz);
            component = ManagedBeanConfigurator.define(clazz, (WebBeansType)WebBeansType.DECORATOR);
            if (component != null) {
                WebBeansDecoratorConfig.configureDecoratorClass((AbstractInjectionTargetBean)component);
            }
        }
        return component;
    }

    protected void clear() {
        this.manager.clear();
        PluginLoader.getInstance().startUp();
    }

    protected AbstractOwbBean<?> getComponent(int i) {
        return this.manager.getComponent(i);
    }

    protected List<AbstractOwbBean<?>> getComponents() {
        return this.manager.getComponents();
    }

    protected int getDeployedComponents() {
        return this.manager.getDeployedCompnents();
    }

    protected Object getInstanceByName(String name) {
        return this.manager.getInstanceByName(name);
    }

    protected Context getContext(Class<? extends Annotation> scopeType) {
        return this.manager.getContext(scopeType);
    }

    protected MockManager getManager() {
        return this.manager;
    }

    protected Object getSession() {
        return new Object();
    }

    protected void configureFromXML(InputStream file, String fileName) {
        this.xmlConfigurator.configure(file, fileName);
    }

    protected void initializeStereoType(Class<? extends Annotation> stereoClass) {
        WebBeansUtil.checkStereoTypeClass(stereoClass);
        StereoTypeModel model = new StereoTypeModel(stereoClass);
        StereoTypeManager.getInstance().addStereoTypeModel((IStereoTypeModel)model);
    }

    protected void initializeInterceptorType(Class<?> interceptorClazz) {
        InterceptorsManager.getInstance().addNewInterceptor(interceptorClazz);
    }

    protected void initializeDecoratorType(Class<?> decoratorClazz) {
        DecoratorsManager.getInstance().addNewDecorator(decoratorClazz);
    }

    @Override
    public void endTests(Object ctx) {
    }

    @Override
    public void startTests(Object ctx) {
    }
}

