/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.subclassing;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import junit.framework.Assert;
import org.apache.webbeans.newtests.subclassing.ClassToGetIntercepted;
import org.junit.Test;

public class TestSubclassCreation {
    @Test
    public void testSubclassCreation() throws Exception {
        Class<ClassToGetIntercepted> ctgiClass = this.createSubClass(ClassToGetIntercepted.class);
        ClassToGetIntercepted ctgi = ctgiClass.newInstance();
        Assert.assertNotNull((Object)ctgi);
        String x = ctgi.getResult();
        Assert.assertEquals((String)"X", (String)x);
    }

    private <T> Class<T> createSubClass(Class<T> cls) throws NotFoundException, CannotCompileException {
        ClassPool pool = ClassPool.getDefault();
        CtClass origClass = pool.get(cls.getName());
        CtClass subClass = pool.makeClass(cls.getName() + "_intcpted", origClass);
        this.overrideInterceptedMethods(subClass);
        Class interceptedClass = subClass.toClass();
        return interceptedClass;
    }

    private void overrideInterceptedMethods(CtClass subClass) throws CannotCompileException {
        CtMethod[] allMethods;
        for (CtMethod method : allMethods = subClass.getMethods()) {
            this.overrideInterceptedMethod(subClass, method);
        }
    }

    private void overrideInterceptedMethod(CtClass subClass, CtMethod method) throws CannotCompileException {
        if (!method.visibleFrom(subClass) || (method.getModifiers() & 0x18) > 0) {
            return;
        }
        String methodName = method.getLongName();
        if (methodName.startsWith("java.lang.Object.")) {
            return;
        }
        CtMethod overridenMethod = CtNewMethod.delegator((CtMethod)method, (CtClass)subClass);
        subClass.addMethod(overridenMethod);
        overridenMethod.insertBefore("{System.out.println(\"juuubel!:\");};");
    }
}

