/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.interceptors.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.interceptors.lifecycle.InterceptorExtension;
import org.apache.webbeans.newtests.interceptors.lifecycle.LifecycleBean;
import org.apache.webbeans.newtests.interceptors.lifecycle.LifecycleInterceptor;
import org.apache.webbeans.newtests.interceptors.lifecycle.NotAnnotatedBean;
import org.junit.Test;

public class LifecycleTest
extends AbstractUnitTest {
    private static final String PACKAGE_NAME = LifecycleTest.class.getPackage().getName();

    @Test
    public void testLifecycle() {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        beanXmls.add(this.getXMLUrl(PACKAGE_NAME, "LifecycleTest"));
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(LifecycleInterceptor.class);
        beanClasses.add(LifecycleBean.class);
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans("org.apache.webbeans.newtests.interceptors.lifecycle.LifecycleBean");
        Assert.assertNotNull((Object)beans);
        Bean lifecycleBean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)lifecycleBean);
        Object reference = this.getBeanManager().getReference(lifecycleBean, LifecycleBean.class, ctx);
        Assert.assertNotNull((Object)reference);
        Assert.assertTrue((boolean)(reference instanceof LifecycleBean));
        Assert.assertTrue((boolean)LifecycleInterceptor.POST_CONSTRUCT);
        Assert.assertNotNull((Object)LifecycleBean.CONSTRUCTOR_INJECTED);
        Assert.assertTrue((!LifecycleInterceptor.PRE_DESTROY ? 1 : 0) != 0);
        lifecycleBean.destroy((Object)((LifecycleBean)reference), ctx);
        this.shutDownContainer();
        Assert.assertTrue((boolean)LifecycleInterceptor.PRE_DESTROY);
    }

    @Test
    public void testNotannotated() {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        beanXmls.add(this.getXMLUrl(PACKAGE_NAME, "LifecycleTest"));
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(NotAnnotatedBean.class);
        beanClasses.add(LifecycleInterceptor.class);
        this.addExtension(new InterceptorExtension());
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans(NotAnnotatedBean.class.getName());
        Assert.assertNotNull((Object)beans);
        Bean notAnnotatedBean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)notAnnotatedBean);
        Object reference = this.getBeanManager().getReference(notAnnotatedBean, NotAnnotatedBean.class, ctx);
        Assert.assertNotNull((Object)reference);
        NotAnnotatedBean nab = (NotAnnotatedBean)reference;
        nab.sayHello();
        Assert.assertTrue((boolean)NotAnnotatedBean.PC);
        this.shutDownContainer();
    }
}

