/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.interceptors.inheritance;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.interceptors.inheritance.Deck;
import org.apache.webbeans.newtests.interceptors.inheritance.DeckChild;
import org.apache.webbeans.newtests.interceptors.inheritance.DeckStereotyped;
import org.apache.webbeans.newtests.interceptors.inheritance.DeckStereotypedChild;
import org.apache.webbeans.newtests.interceptors.inheritance.DeckStereotypedGrandchild;
import org.apache.webbeans.newtests.interceptors.inheritance.DeckStereotypedNotInherited;
import org.apache.webbeans.newtests.interceptors.inheritance.DeckStereotypedNotInheritedChild;
import org.apache.webbeans.newtests.interceptors.inheritance.DeckType;
import org.apache.webbeans.newtests.interceptors.inheritance.InterceptorIncludedByIndirect;
import org.apache.webbeans.newtests.interceptors.inheritance.InterceptorInherited;
import org.apache.webbeans.newtests.interceptors.inheritance.InterceptorInheritedIncludedByIndirect;
import org.apache.webbeans.newtests.interceptors.inheritance.InterceptorMethod;
import org.apache.webbeans.newtests.interceptors.inheritance.InterceptorSimple;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class InheritedInterceptorTest
extends AbstractUnitTest {
    private static final String PACKAGE_NAME = InheritedInterceptorTest.class.getPackage().getName();
    String beansXMLOrdering = "[InterceptorSimple, InterceptorInherited, InterceptorMethod, InterceptorIncludedByIndirect, InterceptorInheritedIncludedByIndirect]";
    String childBeansXMLOrdering = "[InterceptorInherited, InterceptorMethod, InterceptorIncludedByIndirect, InterceptorInheritedIncludedByIndirect]";
    String methodOnlyXMLOrdering = "[InterceptorMethod]";
    Set<Bean<?>> beans = null;

    @Before
    public void setUp() {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        beanXmls.add(this.getXMLUrl(PACKAGE_NAME, "InheritedInterceptorTest"));
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(Deck.class);
        beanClasses.add(DeckChild.class);
        beanClasses.add(DeckStereotyped.class);
        beanClasses.add(DeckStereotypedChild.class);
        beanClasses.add(DeckStereotypedNotInherited.class);
        beanClasses.add(DeckStereotypedNotInheritedChild.class);
        beanClasses.add(DeckStereotypedGrandchild.class);
        beanClasses.add(InterceptorSimple.class);
        beanClasses.add(InterceptorInherited.class);
        beanClasses.add(InterceptorIncludedByIndirect.class);
        beanClasses.add(InterceptorInheritedIncludedByIndirect.class);
        beanClasses.add(InterceptorMethod.class);
        this.startContainer(beanClasses, beanXmls);
        this.beans = this.getBeanManager().getBeans(DeckType.class, new Annotation[0]);
        Assert.assertNotNull((String)"BeanManager.getBeans() returned null", this.beans);
    }

    @After
    public void tearDown() {
        this.shutDownContainer();
    }

    @Test
    public void testNormalScopeNoNewInstance() {
        this.do_testNormalScopeNoNewInstance();
    }

    @Test
    public void testLoopNormalScopeNoNewInstance() {
        for (int i = 0; i < 100; ++i) {
            this.do_testNormalScopeNoNewInstance();
        }
    }

    public void do_testNormalScopeNoNewInstance() {
        for (Bean<?> bean : this.beans) {
            CreationalContext cc = this.getBeanManager().createCreationalContext(null);
            DeckType d1 = (DeckType)this.getBeanManager().getReference(bean, DeckType.class, cc);
            d1.shuffle();
        }
    }

    @Test
    public void testStereotype() {
        for (Bean<?> bean : this.beans) {
            DeckType d = (DeckType)this.getBeanManager().getReference(bean, DeckType.class, this.getBeanManager().createCreationalContext(bean));
            d.shuffle();
            List<String> interceptors = d.getInterceptors();
            System.out.println(d.toString());
            if (d.getName().equals("DeckStereotyped") || d.getName().equals("DeckStereotypedChild") || d.getName().equals("DeckStereotypedGrandchild") || d.getName().equals("DeckStereotypedNotInherited")) {
                Assert.assertEquals((String)d.getName(), (String)this.beansXMLOrdering, (String)interceptors.toString());
                continue;
            }
            if (!d.getName().equals("DeckStereotypedNotInheritedChild")) continue;
            Assert.assertEquals((String)d.getName(), (String)this.methodOnlyXMLOrdering, (String)interceptors.toString());
        }
    }

    @Test
    public void testInterceptorInheritance() {
        for (Bean<?> bean : this.beans) {
            DeckType d = (DeckType)this.getBeanManager().getReference(bean, DeckType.class, this.getBeanManager().createCreationalContext(bean));
            d.shuffle();
            List<String> interceptors = d.getInterceptors();
            System.out.println(d.toString());
            if (d.getName().equals("Deck")) {
                Assert.assertEquals((String)d.getName(), (String)this.beansXMLOrdering, (String)interceptors.toString());
                continue;
            }
            if (!d.getName().equals("DeckChild")) continue;
            Assert.assertEquals((String)d.getName(), (String)this.childBeansXMLOrdering, (String)interceptors.toString());
        }
    }
}

