/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.interceptors.dependent;

import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.interceptors.beans.DependentScopedBean;
import org.apache.webbeans.newtests.interceptors.common.DependentInterceptor;
import org.junit.Test;

public class DependentInterceptorTest
extends AbstractUnitTest {
    private static final String PACKAGE_NAME = DependentInterceptorTest.class.getPackage().getName();

    @Test
    public void testLifecycle() {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        beanXmls.add(this.getXMLUrl(PACKAGE_NAME, "DependentInterceptorTest"));
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(DependentInterceptor.class);
        beanClasses.add(DependentScopedBean.class);
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans("org.apache.webbeans.newtests.interceptors.beans.DependentScopedBean");
        Assert.assertNotNull((Object)beans);
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)bean);
        DependentInterceptor.refCount = 0;
        Object reference = this.getBeanManager().getReference(bean, DependentScopedBean.class, ctx);
        Assert.assertNotNull((Object)reference);
        Assert.assertTrue((boolean)(reference instanceof DependentScopedBean));
        Assert.assertTrue((boolean)DependentScopedBean.POST_CONSTRUCT);
        Assert.assertTrue((!DependentScopedBean.PRE_DESTROY ? 1 : 0) != 0);
        DependentScopedBean dbean = (DependentScopedBean)reference;
        dbean.sayHello();
        Assert.assertTrue((boolean)DependentScopedBean.SAY_HELLO);
        bean.destroy((Object)dbean, ctx);
        this.shutDownContainer();
        Assert.assertTrue((boolean)DependentScopedBean.PRE_DESTROY);
    }
}

