/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.interceptors.business.tests;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.interceptors.beans.ApplicationScopedBean;
import org.apache.webbeans.newtests.interceptors.beans.RequestScopedBean;
import org.apache.webbeans.newtests.interceptors.business.tests.DependingInterceptorTest;
import org.apache.webbeans.newtests.interceptors.common.TransactionInterceptor;
import org.junit.Test;

public class InterceptorPerformanceTest
extends AbstractUnitTest {
    private static final String PACKAGE_NAME = DependingInterceptorTest.class.getPackage().getName();
    private static final int ITERATIONS = 10000;
    private static WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorPerformanceTest.class);

    @Test
    public void testInterceptorPerformance() {
        long start;
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        beanXmls.add(this.getXMLUrl(PACKAGE_NAME, "DependingInterceptorTest"));
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(TransactionInterceptor.class);
        beanClasses.add(ApplicationScopedBean.class);
        beanClasses.add(RequestScopedBean.class);
        TransactionInterceptor.count = 0;
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans(RequestScopedBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)beans);
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)bean);
        Object reference1 = this.getBeanManager().getReference(bean, RequestScopedBean.class, ctx);
        Assert.assertNotNull((Object)reference1);
        Assert.assertTrue((boolean)(reference1 instanceof RequestScopedBean));
        RequestScopedBean beanInstance1 = (RequestScopedBean)reference1;
        TransactionInterceptor.count = 0;
        long startDek = start = System.nanoTime();
        for (int i = 1; i < 10000; ++i) {
            beanInstance1.getMyService().getJ();
            if (i % 100 != 0) continue;
            long endDek = System.nanoTime();
            logger.info("Executing 100 iterations took {0} ns", new Object[]{endDek - startDek});
            startDek = endDek;
        }
        long end = System.nanoTime();
        logger.info("Executing {0} iterations took {1} ns", new Object[]{10000, end - start});
        this.shutDownContainer();
        if ((double)(end - start) / 1000000.0 > 10000.0) {
            Assert.fail((String)"Performance test took more than 20 times longer than it should");
        }
    }
}

