/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.interceptors.business.tests;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.interceptors.beans.ApplicationScopedBean;
import org.apache.webbeans.newtests.interceptors.beans.RequestScopedBean;
import org.apache.webbeans.newtests.interceptors.common.TransactionInterceptor;
import org.junit.Test;

public class DependingInterceptorTest
extends AbstractUnitTest {
    private static final String PACKAGE_NAME = DependingInterceptorTest.class.getPackage().getName();

    @Test
    public void testDependingBeanInterceptor() {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        beanXmls.add(this.getXMLUrl(PACKAGE_NAME, "DependingInterceptorTest"));
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(TransactionInterceptor.class);
        beanClasses.add(ApplicationScopedBean.class);
        beanClasses.add(RequestScopedBean.class);
        TransactionInterceptor.count = 0;
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans(RequestScopedBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)beans);
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)bean);
        Object reference1 = this.getBeanManager().getReference(bean, RequestScopedBean.class, ctx);
        Assert.assertNotNull((Object)reference1);
        Assert.assertTrue((boolean)(reference1 instanceof RequestScopedBean));
        RequestScopedBean beanInstance1 = (RequestScopedBean)reference1;
        TransactionInterceptor.count = 0;
        beanInstance1.getMyService().getJ();
        RequestScopedBean realInstance1 = beanInstance1.getInstance();
        Assert.assertTrue((boolean)TransactionInterceptor.ECHO);
        Assert.assertEquals((int)1, (int)TransactionInterceptor.count);
        TransactionInterceptor.ECHO = false;
        ContextFactory.destroyRequestContext(null);
        ContextFactory.initRequestContext(null);
        CreationalContext ctx2 = this.getBeanManager().createCreationalContext((Contextual)bean);
        Object reference2 = this.getBeanManager().getReference(bean, RequestScopedBean.class, ctx2);
        Assert.assertNotNull((Object)reference2);
        Assert.assertTrue((boolean)(reference2 instanceof RequestScopedBean));
        RequestScopedBean beanInstance2 = (RequestScopedBean)reference2;
        beanInstance2.getMyService().getJ();
        RequestScopedBean realInstance2 = beanInstance2.getInstance();
        Assert.assertTrue((boolean)TransactionInterceptor.ECHO);
        Assert.assertEquals((int)2, (int)TransactionInterceptor.count);
        Assert.assertNotSame((Object)realInstance1, (Object)realInstance2);
        Assert.assertEquals((int)realInstance1.getMyService().getJ(), (int)realInstance2.getMyService().getJ());
        this.shutDownContainer();
    }

    @Test
    public void testInterceptorCreation() throws Exception {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        beanXmls.add(this.getXMLUrl(PACKAGE_NAME, "DependingInterceptorTest"));
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(TransactionInterceptor.class);
        beanClasses.add(ApplicationScopedBean.class);
        TransactionInterceptor.count = 0;
        TransactionInterceptor.interceptorCount = 0;
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans(ApplicationScopedBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)beans);
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)bean);
        Object reference1 = this.getBeanManager().getReference(bean, ApplicationScopedBean.class, ctx);
        Assert.assertNotNull((Object)reference1);
        ApplicationScopedBean app = (ApplicationScopedBean)reference1;
        app.getJ();
        Assert.assertTrue((TransactionInterceptor.interceptorCount == 1 ? 1 : 0) != 0);
        app.getJ();
        Assert.assertTrue((TransactionInterceptor.interceptorCount == 1 ? 1 : 0) != 0);
        app.getJ();
        Assert.assertTrue((TransactionInterceptor.interceptorCount == 1 ? 1 : 0) != 0);
    }
}

