/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.injection.circular.tests;

import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import junit.framework.Assert;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.injection.circular.beans.CircularApplicationScopedBean;
import org.apache.webbeans.newtests.injection.circular.beans.CircularDependentScopedBean;
import org.junit.Test;

public class CircularInjectionTest
extends AbstractUnitTest {
    @Test
    public void testOneNormalOneDependent() {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(CircularDependentScopedBean.class);
        beanClasses.add(CircularApplicationScopedBean.class);
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans("org.apache.webbeans.newtests.injection.circular.beans.CircularApplicationScopedBean");
        Assert.assertNotNull((Object)beans);
        Bean dependentBean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)dependentBean);
        Object reference = this.getBeanManager().getReference(dependentBean, CircularApplicationScopedBean.class, ctx);
        Assert.assertTrue((boolean)(reference instanceof CircularApplicationScopedBean));
        CircularApplicationScopedBean beanInstance = (CircularApplicationScopedBean)reference;
        beanInstance.hello();
        Assert.assertTrue((boolean)CircularDependentScopedBean.success);
        Assert.assertTrue((boolean)CircularApplicationScopedBean.success);
        this.shutDownContainer();
    }

    @Test
    public void testOneDependentOneNormal() {
        ArrayList<URL> beanXmls = new ArrayList<URL>();
        ArrayList beanClasses = new ArrayList();
        beanClasses.add(CircularDependentScopedBean.class);
        beanClasses.add(CircularApplicationScopedBean.class);
        this.startContainer(beanClasses, beanXmls);
        Set beans = this.getBeanManager().getBeans("org.apache.webbeans.newtests.injection.circular.beans.CircularDependentScopedBean");
        Assert.assertNotNull((Object)beans);
        Bean dependentBean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)dependentBean);
        Object reference = this.getBeanManager().getReference(dependentBean, CircularDependentScopedBean.class, ctx);
        Assert.assertTrue((boolean)(reference instanceof CircularDependentScopedBean));
        Assert.assertTrue((boolean)CircularDependentScopedBean.success);
        Assert.assertTrue((boolean)CircularApplicationScopedBean.success);
        this.shutDownContainer();
    }
}

