/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.contexts.threadsafety;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import junit.framework.Assert;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.contexts.threadsafety.LongInitApplicationBean;
import org.apache.webbeans.spi.ContextsService;
import org.junit.Test;

public class ThreadSafeBeanInitialisationTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(ThreadSafeBeanInitialisationTest.class.getName());

    @Test
    public void testBeanCreation() throws Exception {
        ArrayList classes = new ArrayList();
        classes.add(LongInitApplicationBean.class);
        this.startContainer(classes);
        BeanManager bm = this.getLifecycle().getBeanManager();
        ParallelBeanStarter bs1 = new ParallelBeanStarter(bm, this.getLifecycle().getContextService());
        ParallelBeanStarter bs2 = new ParallelBeanStarter(bm, this.getLifecycle().getContextService());
        ParallelBeanStarter bs3 = new ParallelBeanStarter(bm, this.getLifecycle().getContextService());
        bs1.start();
        bs2.start();
        bs3.start();
        bs1.join();
        bs2.join();
        bs3.join();
        Assert.assertTrue((bs1.getLongInitBean().getThis() == bs2.getLongInitBean().getThis() ? 1 : 0) != 0);
        Assert.assertTrue((bs1.getLongInitBean().getThis() == bs3.getLongInitBean().getThis() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)bs1.isFailed());
        Assert.assertFalse((boolean)bs2.isFailed());
        Assert.assertFalse((boolean)bs3.isFailed());
    }

    private static class ParallelBeanStarter
    extends Thread {
        private BeanManager bm;
        private LongInitApplicationBean longInitBean;
        private ContextsService cs;
        private boolean failed = true;

        public ParallelBeanStarter(BeanManager bm, ContextsService cs) {
            this.bm = bm;
            this.cs = cs;
        }

        public LongInitApplicationBean getLongInitBean() {
            return this.longInitBean;
        }

        public boolean isFailed() {
            return this.failed;
        }

        @Override
        public void run() {
            try {
                this.cs.startContext(RequestScoped.class, null);
                Set beans = this.bm.getBeans(LongInitApplicationBean.class, new Annotation[0]);
                Assert.assertNotNull((Object)beans);
                Assert.assertTrue((beans.size() == 1 ? 1 : 0) != 0);
                Bean lrBean = (Bean)beans.iterator().next();
                CreationalContext lrCreational = this.bm.createCreationalContext((Contextual)lrBean);
                Assert.assertNotNull((Object)lrCreational);
                this.longInitBean = (LongInitApplicationBean)this.bm.getReference(lrBean, LongInitApplicationBean.class, lrCreational);
                int i = this.longInitBean.getI();
                Assert.assertEquals((int)1, (int)i);
                this.failed = false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "ThreadSafeTest", e);
                Assert.fail();
            }
        }
    }
}

