/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.contexts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import junit.framework.Assert;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.container.SerializableBeanVault;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.type.ContextTypes;
import org.apache.webbeans.newtests.AbstractUnitTest;
import org.apache.webbeans.newtests.contexts.serialize.AppScopedBean;
import org.apache.webbeans.newtests.contexts.serialize.SessScopedBean;
import org.apache.webbeans.newtests.contexts.session.common.PersonalDataBean;
import org.apache.webbeans.newtests.decorators.multiple.Decorator1;
import org.apache.webbeans.newtests.decorators.multiple.OutputProvider;
import org.apache.webbeans.newtests.decorators.multiple.RequestStringBuilder;
import org.apache.webbeans.newtests.injection.circular.beans.CircularApplicationScopedBean;
import org.apache.webbeans.newtests.injection.circular.beans.CircularConstructorOrProducerMethodParameterBean;
import org.apache.webbeans.newtests.injection.circular.beans.CircularDependentScopedBean;
import org.apache.webbeans.newtests.injection.circular.beans.CircularNormalInConstructor;
import org.apache.webbeans.test.component.CheckWithCheckPayment;
import org.apache.webbeans.test.component.CheckWithMoneyPayment;
import org.apache.webbeans.test.component.IPayment;
import org.apache.webbeans.test.component.PaymentProcessorComponent;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves1;
import org.apache.webbeans.test.component.event.normal.ComponentWithObserves2;
import org.apache.webbeans.test.component.event.normal.TransactionalInterceptor;
import org.apache.webbeans.util.WebBeansUtil;
import org.junit.Test;

public class SerializationTest
extends AbstractUnitTest {
    @Test
    public void testCreationalContextSerialization() throws Exception {
        ArrayList classes = new ArrayList();
        classes.add(PersonalDataBean.class);
        classes.add(CircularDependentScopedBean.class);
        classes.add(CircularApplicationScopedBean.class);
        this.startContainer(classes);
        BeanManager bm = this.getLifecycle().getBeanManager();
        Set beans = this.getLifecycle().getBeanManager().getBeans(PersonalDataBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)beans);
        Assert.assertTrue((beans.size() == 1 ? 1 : 0) != 0);
        Bean pdbBean = (Bean)beans.iterator().next();
        CreationalContext pdbCreational = bm.createCreationalContext((Contextual)pdbBean);
        Assert.assertNotNull((Object)pdbCreational);
        byte[] serial = this.serializeObject(pdbCreational);
        CreationalContext cc2 = (CreationalContext)this.deSerializeObject(serial);
        Assert.assertNotNull((Object)cc2);
    }

    @Test
    public void testPersonalDataBean() throws ClassNotFoundException, IOException {
        ArrayList classes = new ArrayList();
        classes.add(PersonalDataBean.class);
        classes.add(OutputProvider.class);
        classes.add(Decorator1.class);
        classes.add(CircularApplicationScopedBean.class);
        classes.add(CircularDependentScopedBean.class);
        classes.add(RequestStringBuilder.class);
        classes.add(CircularConstructorOrProducerMethodParameterBean.class);
        classes.add(CircularDependentScopedBean.class);
        classes.add(CircularNormalInConstructor.class);
        classes.add(TransactionalInterceptor.class);
        classes.add(ComponentWithObserves1.class);
        classes.add(ComponentWithObserves2.class);
        classes.add(PaymentProcessorComponent.class);
        classes.add(IPayment.class);
        classes.add(CheckWithCheckPayment.class);
        classes.add(CheckWithMoneyPayment.class);
        this.startContainer(classes);
        Set beans = this.getLifecycle().getBeanManager().getBeans(Object.class, new Annotation[0]);
        Assert.assertNotNull((Object)beans);
        Assert.assertTrue((beans.size() > 7 ? 1 : 0) != 0);
        for (Bean bean : beans) {
            String id = null;
            id = WebBeansUtil.isPassivationCapable((Contextual)bean);
            if (id == null) continue;
            bean = (Bean)SerializableBeanVault.getInstance().getSerializableBean((Contextual)bean);
            byte[] serial = this.serializeBean(bean);
            Bean<?> b2 = this.deSerializeBean(serial);
            Assert.assertEquals((Object)((SerializableBean)bean).getBean(), (Object)((SerializableBean)b2).getBean());
        }
        PersonalDataBean pdb = this.getInstance(PersonalDataBean.class, new Annotation[0]);
        pdb.business();
        Context sessionContext = ContextFactory.getStandardContext((ContextTypes)ContextTypes.SESSION);
        Assert.assertNotNull((Object)sessionContext);
        byte[] ba = this.serializeObject(sessionContext);
        Assert.assertNotNull((Object)ba);
        Context sessContext2 = (Context)this.deSerializeObject(ba);
        Assert.assertNotNull((Object)sessContext2);
    }

    public void testProxySerialization() throws Exception {
        ArrayList classes = new ArrayList();
        classes.add(SessScopedBean.class);
        classes.add(AppScopedBean.class);
        this.startContainer(classes);
        Set beans = this.getLifecycle().getBeanManager().getBeans(SessScopedBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)beans);
        Assert.assertTrue((beans.size() == 1 ? 1 : 0) != 0);
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ssbCreational = this.getBeanManager().createCreationalContext((Contextual)bean);
        Assert.assertNotNull((Object)ssbCreational);
        SessScopedBean reference = (SessScopedBean)this.getBeanManager().getReference(bean, SessScopedBean.class, ssbCreational);
        Assert.assertNotNull((Object)reference);
        Assert.assertTrue((boolean)(reference instanceof ProxyObject));
        reference.getApp().setI(4711);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(reference);
        byte[] ba = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        ObjectInputStream ois = new ObjectInputStream(bais);
        SessScopedBean ssb2 = (SessScopedBean)ois.readObject();
        Assert.assertNotNull((Object)ssb2);
        Assert.assertNotNull((Object)ssb2.getApp());
        Assert.assertTrue((ssb2.getApp().getI() == 4711 ? 1 : 0) != 0);
    }

    private byte[] serializeBean(Bean<?> bean) throws IOException {
        return this.serializeObject(bean);
    }

    private byte[] serializeObject(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        return baos.toByteArray();
    }

    private Bean<?> deSerializeBean(byte[] serial) throws IOException, ClassNotFoundException {
        return (Bean)this.deSerializeObject(serial);
    }

    private Object deSerializeObject(byte[] serial) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(serial);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }
}

