/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests.config;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.webbeans.config.PropertyLoader;
import org.apache.webbeans.newtests.config.MockPropertyLoader;
import org.junit.Assert;
import org.junit.Test;

public class PropertyLoaderTest {
    private static final String PROPERTY_FILE = "org/apache/webbeans/newtests/config/propertyloadertest.properties";
    private static final String PROPERTY_FILE2 = "org/apache/webbeans/newtests/config/propertyloadertest2.properties";
    private static final String PROPERTY_FILE3 = "org/apache/webbeans/newtests/config/propertyloadertest3.properties";

    @Test
    public void testPropertyLoader() throws Exception {
        Properties p = PropertyLoader.getProperties((String)PROPERTY_FILE);
        Assert.assertNotNull((Object)p);
        String testValue = p.getProperty("testConfig");
        Assert.assertNotNull((Object)testValue);
        Assert.assertEquals((Object)"testValue", (Object)testValue);
    }

    @Test
    public void testNonExistentProperties() {
        Properties p = PropertyLoader.getProperties((String)"notexisting.properties");
        Assert.assertNull((Object)p);
    }

    @Test
    public void testOrdinal() {
        Properties p15 = PropertyLoader.getProperties((String)PROPERTY_FILE);
        Properties p16 = PropertyLoader.getProperties((String)PROPERTY_FILE2);
        Properties p20 = PropertyLoader.getProperties((String)PROPERTY_FILE3);
        ArrayList<Properties> properties = new ArrayList<Properties>();
        properties.add(p15);
        properties.add(p16);
        properties.add(p20);
        Properties prop = MockPropertyLoader.mergeProperties(MockPropertyLoader.sortProperties(properties));
        Assert.assertEquals((Object)"testValue16", (Object)prop.get("testConfig"));
        Assert.assertEquals((Object)"16", (Object)prop.get("test16"));
        Assert.assertEquals((Object)"15", (Object)prop.get("test15"));
        Assert.assertEquals((Object)"20", (Object)prop.get("configuration.ordinal"));
        Assert.assertEquals((Object)"z", (Object)prop.get("override_y"));
        Assert.assertEquals((Object)"20", (Object)prop.get("override_all"));
        Assert.assertEquals((Object)"15", (Object)prop.get("unique_1"));
        Assert.assertEquals((Object)"16", (Object)prop.get("unique_2"));
        Assert.assertEquals((Object)"20", (Object)prop.get("unique_3"));
    }
}

