/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.newtests;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.lifecycle.test.OpenWebBeansTestLifeCycle;
import org.apache.webbeans.lifecycle.test.OpenWebBeansTestMetaDataDiscoveryService;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.junit.Assert;

public abstract class AbstractUnitTest {
    private OpenWebBeansTestLifeCycle testLifecycle;
    private List<Extension> extensions = new ArrayList<Extension>();

    protected AbstractUnitTest() {
    }

    protected void startContainer(Collection<Class<?>> beanClasses) {
        this.testLifecycle = new OpenWebBeansTestLifeCycle();
        for (Extension ext : this.extensions) {
            ExtensionLoader.getInstance().addExtension(ext);
        }
        OpenWebBeansTestMetaDataDiscoveryService discoveyService = (OpenWebBeansTestMetaDataDiscoveryService)this.testLifecycle.getScannerService();
        discoveyService.deployClasses(beanClasses);
        try {
            this.testLifecycle.startApplication(null);
        }
        catch (Exception e) {
            throw new WebBeansConfigurationException((Throwable)e);
        }
    }

    protected void startContainer(Collection<Class<?>> beanClasses, Collection<URL> beanXmls) {
        this.testLifecycle = new OpenWebBeansTestLifeCycle();
        for (Extension ext : this.extensions) {
            ExtensionLoader.getInstance().addExtension(ext);
        }
        OpenWebBeansTestMetaDataDiscoveryService discoveyService = (OpenWebBeansTestMetaDataDiscoveryService)this.testLifecycle.getScannerService();
        discoveyService.deployClasses(beanClasses);
        discoveyService.deployXMLs(beanXmls);
        try {
            this.testLifecycle.startApplication(null);
        }
        catch (Exception e) {
            throw new WebBeansConfigurationException((Throwable)e);
        }
    }

    protected void shutDownContainer() {
        if (this.testLifecycle != null) {
            this.testLifecycle.stopApplication(null);
        }
    }

    protected OpenWebBeansTestLifeCycle getLifecycle() {
        return this.testLifecycle;
    }

    protected BeanManager getBeanManager() {
        return this.testLifecycle.getBeanManager();
    }

    protected <T> T getInstance(Class<T> type, Annotation ... qualifiers) {
        Set beans = this.getBeanManager().getBeans(type, qualifiers);
        Assert.assertNotNull((Object)beans);
        Assert.assertTrue((String)("resolving bean with type" + type + " is ambiguous or bean is not found!"), (beans.size() == 1 ? 1 : 0) != 0);
        Bean bean = (Bean)beans.iterator().next();
        return (T)this.getBeanManager().getReference(bean, type, this.getBeanManager().createCreationalContext((Contextual)bean));
    }

    protected URL getXMLUrl(String packageName, String fileName) {
        StringBuilder prefix = new StringBuilder(packageName.replace('.', '/'));
        prefix.append("/");
        prefix.append(fileName);
        prefix.append(".xml");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResource(prefix.toString());
    }

    public void addExtension(Extension ext) {
        this.extensions.add(ext);
    }
}

