/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.context;

import java.util.Map;

import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

import org.apache.webbeans.context.creational.BeanInstanceBag;
import org.apache.webbeans.context.type.ContextTypes;


/**
 * Defines spi for contexts.
 * 
 * @version $Rev: 952250 $ $Date: 2010-06-07 16:39:41 +0200 (Mo, 07 Jun 2010) $
 */
public interface WebBeansContext extends javax.enterprise.context.spi.Context
{   
    /**
     * Initializes this contextual bag with
     * given creational context.
     * <p>
     * Given creational context is used fot creating the
     * bean instance.
     * </p>
     * @param <T> type
     * @param contextual contextual bean
     * @param creationalContext creational context
     */
    public <T> void initContextualBag(Contextual<T> contextual, CreationalContext<T> creationalContext);
    
    /**
     * Destroys the context.
     */
    public void destroy();
    
    /**
     * Returns context type.
     * 
     * @return context type
     */
    public ContextTypes getType();
    
    /**
     * Returns instance map.
     * 
     * @return instance map
     */
    public Map<Contextual<?>, BeanInstanceBag<?>> getComponentInstanceMap();
    
    /**
     * Gets creational context of the given bean.
     * @param <T> type
     * @param contextual contextual bean
     * @return creational context of the given bean
     */
    public <T> CreationalContext<T> getCreationalContext(Contextual<T> contextual);
}