/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ee.event;

import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.TransactionService;

public class TransactionalEventNotifier {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(TransactionalEventNotifier.class);

    public static void registerTransactionSynchronization(TransactionPhase phase, ObserverMethod<? super Object> observer, Object event) throws Exception {
        TransactionService transactionService = (TransactionService)ServiceLoader.getService(TransactionService.class);
        Transaction transaction = null;
        if (transactionService != null) {
            transaction = transactionService.getTransaction();
        }
        if (transaction != null) {
            if (phase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
                transaction.registerSynchronization((Synchronization)new AfterCompletion(observer, event));
            } else if (phase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
                transaction.registerSynchronization((Synchronization)new AfterCompletionSuccess(observer, event));
            } else if (phase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
                transaction.registerSynchronization((Synchronization)new AfterCompletionFailure(observer, event));
            } else if (phase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) {
                transaction.registerSynchronization((Synchronization)new BeforeCompletion(observer, event));
            } else {
                throw new IllegalStateException(logger.getTokenString("EXCEPT_0007") + phase);
            }
        }
    }

    private static class AfterCompletionFailure
    extends AbstractSynchronization {
        private AfterCompletionFailure(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void afterCompletion(int i) {
            if (i != 3) {
                this.notifyObserver();
            }
        }
    }

    private static class AfterCompletionSuccess
    extends AbstractSynchronization {
        private AfterCompletionSuccess(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void afterCompletion(int i) {
            if (i == 3) {
                this.notifyObserver();
            }
        }
    }

    private static class AfterCompletion
    extends AbstractSynchronization {
        private AfterCompletion(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void afterCompletion(int i) {
            this.notifyObserver();
        }
    }

    private static class BeforeCompletion
    extends AbstractSynchronization {
        private BeforeCompletion(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void beforeCompletion() {
            this.notifyObserver();
        }
    }

    private static class AbstractSynchronization<T>
    implements Synchronization {
        private final ObserverMethod<T> observer;
        private final T event;

        public AbstractSynchronization(ObserverMethod<T> observer, T event) {
            this.observer = observer;
            this.event = event;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
        }

        public void notifyObserver() {
            try {
                this.observer.notify(this.event);
            }
            catch (Exception e) {
                logger.error("ERROR_0003", (Throwable)e);
            }
        }
    }
}

