/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.FailOverService;

public class FailOverBag
implements Serializable,
Externalizable {
    public static final String SESSION_ATTRIBUTE_NAME = "o.a.owb.FAIL_OVER_BAG";
    private static final Logger LOGGER = WebBeansLoggerFacade.getLogger(FailOverBag.class);
    private static final long serialVersionUID = -6314819837009653190L;
    private transient FailOverService failOverService;
    private Map<String, Object> items;
    private boolean sessionInUse;
    private String sessionId;
    private String jvmId;

    public FailOverBag() {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        this.failOverService = (FailOverService)webBeansContext.getService(FailOverService.class);
        this.items = new HashMap<String, Object>();
    }

    public FailOverBag(String sessionId, String jvmId) {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        this.failOverService = (FailOverService)webBeansContext.getService(FailOverService.class);
        this.items = new HashMap<String, Object>();
        this.sessionId = sessionId;
        this.jvmId = jvmId;
    }

    public void put(String name, Object item) {
        this.items.put(name, item);
    }

    public Object get(String name) {
        return this.items.get(name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sessionInUse = in.readBoolean();
        this.sessionId = (String)in.readObject();
        this.jvmId = (String)in.readObject();
        if (this.sessionInUse) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Skip bean de-serialization because session with id [" + this.sessionId + "] is in use.");
            }
            return;
        }
        byte[] buffer = (byte[])in.readObject();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = this.failOverService.getObjectInputStream((InputStream)bais);
        this.items = (Map)ois.readObject();
        ois.close();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.sessionInUse);
        out.writeObject(this.sessionId);
        out.writeObject(this.jvmId);
        if (this.sessionInUse) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Skip bean serialization because session with id [" + this.sessionId + "] is in use.");
            }
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = this.failOverService.getObjectOutputStream((OutputStream)baos);
        oos.writeObject(this.items);
        oos.flush();
        out.writeObject(baos.toByteArray());
        oos.close();
        baos.close();
    }

    public boolean isSessionInUse() {
        return this.sessionInUse;
    }

    public void setSessionInUse(boolean sessionInUse) {
        this.sessionInUse = sessionInUse;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getJvmId() {
        return this.jvmId;
    }

    public void setJvmId(String jvmId) {
        this.jvmId = jvmId;
    }
}

