/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.arquillian.standalone;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class OwbSWClassLoader
extends URLClassLoader {
    private static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private final List<InputStream> openedStreams = new ArrayList<InputStream>();
    private final String prefix;
    private final boolean useOnlyArchiveResources;
    private final Archive<?> archive;
    private final Collection<String> useOnlyArchiveResourcesExcludes;

    public OwbSWClassLoader(ClassLoader parent, Archive<?> archive, boolean useOnlyArchiveResources, Collection<String> useOnlyArchiveResourcesExcludes) {
        super(new URL[0], parent);
        this.useOnlyArchiveResources = useOnlyArchiveResources;
        this.useOnlyArchiveResourcesExcludes = useOnlyArchiveResourcesExcludes;
        this.archive = archive;
        this.prefix = WebArchive.class.isInstance(archive) ? "/WEB-INF/classes" : "";
        try {
            this.addURL(new URL(null, "archive:" + archive.getName() + "/", new ArchiveStreamHandler()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create URL for archive: " + archive.getName(), e);
        }
    }

    @Override
    public URL getResource(String name) {
        URL url;
        if (this.useOnlyArchiveResources && (url = this.findResource(name)) != null) {
            return url;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.useOnlyArchiveResources) {
            Enumeration<URL> urls = this.findResources(name);
            if (this.useOnlyArchiveResourcesExcludes.contains(name)) {
                ArrayList<URL> returnValue = new ArrayList<URL>(Collections.list(urls));
                returnValue.addAll(Collections.list(super.getResources(name)));
                return Collections.enumeration(returnValue);
            }
            if (urls.hasMoreElements()) {
                return urls;
            }
        }
        return super.getResources(name);
    }

    @Override
    public URL findResource(String name) {
        Set<String> nodes = this.findNodes(this.archive, name);
        if (!nodes.isEmpty()) {
            try {
                return new URL(null, "archive:" + nodes.iterator().next(), new ArchiveStreamHandler());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.useOnlyArchiveResources) {
            return null;
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Set<String> nodes = this.findNodes(this.archive, name);
        ArrayList<URL> urls = new ArrayList<URL>(nodes.size());
        for (String node : nodes) {
            urls.add(new URL(null, "archive:" + node, new ArchiveStreamHandler()));
        }
        return Collections.enumeration(urls);
    }

    private Set<String> findNodes(Archive arch, String name) {
        HashSet<String> nodes = new HashSet<String>();
        if (arch instanceof WebArchive) {
            ArchivePath path = ArchivePaths.create((String)this.path(this.prefix, name));
            Node node = arch.get(path);
            if (node != null) {
                nodes.add(path.get());
            }
            Map jarLibs = ((WebArchive)arch).getContent(Filters.include((String)"/WEB-INF/lib/.*\\.jar"));
            for (Node jarLib : jarLibs.values()) {
                if (!(jarLib.getAsset() instanceof ArchiveAsset) || !(((ArchiveAsset)jarLib.getAsset()).getArchive() instanceof JavaArchive)) continue;
                Set<String> jarNodes = this.findNodes(((ArchiveAsset)jarLib.getAsset()).getArchive(), name);
                for (String jarNode : jarNodes) {
                    path = ArchivePaths.create((String)this.path("WEB-INF/lib", ((ArchiveAsset)jarLib.getAsset()).getArchive().getName(), jarNode));
                    nodes.add(path.get());
                }
            }
        } else {
            ArchivePath path = ArchivePaths.create((String)name);
            Node node = arch.get(path);
            if (node != null) {
                nodes.add(path.get());
            }
        }
        return nodes;
    }

    private String path(String ... parts) {
        StringBuilder builder = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            if (!parts[i - 1].endsWith("/") && !parts[i].startsWith("/")) {
                builder.append("/");
            }
            builder.append(parts[i]);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        OwbSWClassLoader owbSWClassLoader = this;
        synchronized (owbSWClassLoader) {
            for (InputStream stream : this.openedStreams) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
            this.openedStreams.clear();
        }
    }

    protected class ArchiveStreamHandler
    extends URLStreamHandler {
        protected ArchiveStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(final URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public InputStream getInputStream() throws IOException {
                    ArchivePath path = this.convertToArchivePath(u);
                    Node node = OwbSWClassLoader.this.archive.get(OwbSWClassLoader.this.prefix + path.get());
                    if (node == null && !OwbSWClassLoader.this.prefix.isEmpty()) {
                        node = OwbSWClassLoader.this.archive.get(path);
                    }
                    if (node == null) {
                        throw new FileNotFoundException("Requested path: " + path + " does not exist in " + OwbSWClassLoader.this.archive.toString());
                    }
                    Asset asset = node.getAsset();
                    if (asset == null) {
                        return null;
                    }
                    InputStream input = asset.openStream();
                    1 var5_5 = this;
                    synchronized (var5_5) {
                        OwbSWClassLoader.this.openedStreams.add(input);
                    }
                    return input;
                }

                private ArchivePath convertToArchivePath(URL url) {
                    return ArchivePaths.create((String)url.getPath().replace(OwbSWClassLoader.this.archive.getName(), ""));
                }
            };
        }
    }
}

