/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.arquillian.standalone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.arquillian.standalone.UrlSet;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.BdaScannerService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class OwbArquillianScannerService
implements BdaScannerService {
    private static final Logger logger = Logger.getLogger(OwbArquillianScannerService.class.getName());
    private static final String WEB_INF_CLASS_FOLDER = "/WEB-INF/classes/";
    private final boolean beansXmlBdaScanningEnabled;
    private final WebBeansContext webBeansContext;
    private final BeanManager beanManager;
    private final BeanArchiveService beanArchiveService;
    private Archive archive;
    private UrlSet beansXmls = new UrlSet();
    private Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> beanClassesPerBda = new HashMap();

    public OwbArquillianScannerService() {
        this.beansXmlBdaScanningEnabled = false;
        this.webBeansContext = WebBeansContext.getInstance();
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
        this.beanArchiveService = this.webBeansContext.getBeanArchiveService();
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    public void init(Object object) {
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public void scan() {
        if (this.archive == null) {
            this.archive = null;
            return;
        }
        String archiveName = this.archive.getName();
        if (archiveName.endsWith(".jar")) {
            this.scanJarArchive(this.archive);
        } else if (archiveName.endsWith(".war")) {
            this.scanWebArchive(this.archive);
        } else {
            throw new IllegalStateException("Scanning of Archive " + this.archive.getClass().getName() + "Not yet implemented");
        }
    }

    public Set<URL> getBeanXmls() {
        return this.beansXmls;
    }

    public Set<Class<?>> getBeanClasses() {
        return Collections.EMPTY_SET;
    }

    public Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> getBeanClassesPerBda() {
        return this.beanClassesPerBda;
    }

    public void release() {
        this.beansXmls.clear();
        this.beanClassesPerBda.clear();
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.beansXmlBdaScanningEnabled;
    }

    private void scanWebArchive(Archive<?> archive) {
        URL metainfBeansXmlUrl;
        URL webBeansXmlUrl = this.getBeanXmlUrl(archive, "WEB-INF/beans.xml");
        if (webBeansXmlUrl != null) {
            this.beansXmls.add(webBeansXmlUrl);
        }
        if ((metainfBeansXmlUrl = this.getBeanXmlUrl(archive, "/WEB-INF/classes/META-INF/beans.xml")) != null) {
            this.beansXmls.add(metainfBeansXmlUrl);
        }
        if (metainfBeansXmlUrl != null || webBeansXmlUrl != null) {
            BeanArchiveService.BeanArchiveInformation info = this.beanArchiveService.getBeanArchiveInformation(webBeansXmlUrl != null ? webBeansXmlUrl : metainfBeansXmlUrl);
            Map classes = archive.getContent(Filters.include((String)"/WEB-INF/classes/.*\\.class"));
            this.scanClasses(info, classes, WEB_INF_CLASS_FOLDER);
        }
        Map jars = archive.getContent(Filters.include((String)"/WEB-INF/lib/.*\\.jar"));
        for (Map.Entry jarEntry : jars.entrySet()) {
            FileAsset fileAsset;
            Asset asset = ((Node)jarEntry.getValue()).getAsset();
            if (asset instanceof FileAsset && (fileAsset = (FileAsset)asset).getSource().getName().endsWith(".jar")) {
                Archive fileArchive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)fileAsset.getSource());
                asset = new ArchiveAsset(fileArchive, ZipExporter.class);
            }
            if (!(asset instanceof ArchiveAsset)) continue;
            ArchiveAsset archiveAsset = (ArchiveAsset)asset;
            JavaArchive jarArchive = (JavaArchive)archiveAsset.getArchive();
            this.scanJarArchive((Archive<?>)jarArchive);
        }
    }

    private void scanJarArchive(Archive<?> archive) {
        URL beansXmlUrl = this.getBeanXmlUrl(archive, "META-INF/beans.xml");
        if (beansXmlUrl == null) {
            beansXmlUrl = this.getBeanXmlUrl(archive, "/");
        }
        this.beansXmls.add(beansXmlUrl);
        Map classes = archive.getContent(Filters.include((String)".*\\.class"));
        this.scanClasses(this.beanArchiveService.getBeanArchiveInformation(beansXmlUrl), classes, null);
    }

    private void scanClasses(BeanArchiveService.BeanArchiveInformation info, Map<ArchivePath, Node> classes, String classBasePath) {
        Set<Class<?>> bdaClasses = this.beanClassesPerBda.get(info);
        if (bdaClasses == null) {
            bdaClasses = new HashSet();
            this.beanClassesPerBda.put(info, bdaClasses);
        }
        if (info != null && info.getBeanDiscoveryMode() == BeanArchiveService.BeanDiscoveryMode.NONE) {
            return;
        }
        for (Map.Entry<ArchivePath, Node> classEntry : classes.entrySet()) {
            String className = classEntry.getKey().get();
            if (classBasePath != null && className.startsWith(WEB_INF_CLASS_FOLDER)) {
                className = className.substring(WEB_INF_CLASS_FOLDER.length());
            }
            if (className.startsWith("/")) {
                className = className.substring(1);
            }
            className = className.substring(0, className.length() - ".class".length());
            className = className.replace('/', '.');
            Class<?> beanClass = null;
            try {
                beanClass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not scan class", cnfe);
            }
            catch (NoClassDefFoundError | UnsatisfiedLinkError ce) {
                logger.info("Error while loading class - ignoring class " + className + " " + ce.getMessage());
                continue;
            }
            if (info != null && info.isClassExcluded(className)) continue;
            if (info != null && info.getBeanDiscoveryMode() == BeanArchiveService.BeanDiscoveryMode.ANNOTATED) {
                boolean hasBeanDefiningAnnotation = false;
                for (Annotation annotation : beanClass.getAnnotations()) {
                    if (!this.isBeanDefiningAnnotation(annotation)) continue;
                    hasBeanDefiningAnnotation = true;
                    break;
                }
                if (!hasBeanDefiningAnnotation) continue;
            }
            bdaClasses.add(beanClass);
        }
    }

    protected boolean isBeanDefiningAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        boolean isBeanAnnotation = this.beanManager.isScope(annotationType);
        isBeanAnnotation = isBeanAnnotation || this.beanManager.isStereotype(annotationType);
        return isBeanAnnotation;
    }

    private URL getBeanXmlUrl(Archive archive, String beansXmlPath) {
        final Node beansXml = archive.get(beansXmlPath);
        if (beansXml == null) {
            return null;
        }
        try {
            String urlLocation = "archive://" + archive.getName() + "/" + beansXmlPath;
            return new URL(null, urlLocation, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return beansXml.getAsset().openStream();
                        }
                    };
                }
            });
        }
        catch (Exception e) {
            RuntimeException runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("Error while parsing beans.xml location", e);
            throw runtimeException;
        }
    }

    public void clear() {
        this.archive = null;
        this.beansXmls = new UrlSet();
        this.beanClassesPerBda = new HashMap();
    }
}

