/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.arquillian.standalone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.arquillian.standalone.UrlSet;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ScannerService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class OwbArquillianScannerService
implements ScannerService {
    private static final String WEB_INF_CLASS_FOLDER = "/WEB-INF/classes/";
    private final boolean beansXmlBdaScanningEnabled;
    private final WebBeansContext webBeansContext;
    private final BeanArchiveService archiveService;
    private Archive archive;
    private UrlSet beansXmls = new UrlSet();
    private Set<Class<?>> beanClasses = new HashSet();

    public OwbArquillianScannerService() {
        this.beansXmlBdaScanningEnabled = false;
        this.webBeansContext = WebBeansContext.getInstance();
        this.archiveService = this.webBeansContext.getBeanArchiveService();
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    public void init(Object object) {
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    public void scan() {
        if (this.archive == null) {
            this.archive = null;
            return;
        }
        String archiveName = this.archive.getName();
        if (archiveName.endsWith(".jar")) {
            this.scanJarArchive(this.archive);
        } else if (archiveName.endsWith(".war")) {
            this.scanWebArchive(this.archive);
        } else {
            throw new IllegalStateException("Scanning of Archive " + this.archive.getClass().getName() + "Not yet implemented");
        }
    }

    public Set<URL> getBeanXmls() {
        return this.beansXmls;
    }

    public Set<Class<?>> getBeanClasses() {
        return this.beanClasses;
    }

    public void release() {
        this.beansXmls.clear();
        this.beanClasses.clear();
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.beansXmlBdaScanningEnabled;
    }

    private void scanWebArchive(Archive<?> archive) {
        URL metainfBeansXmlUrl;
        URL webBeansXmlUrl = this.getBeanXmlUrl(archive, "WEB-INF/beans.xml");
        if (webBeansXmlUrl != null) {
            this.beansXmls.add(webBeansXmlUrl);
        }
        if ((metainfBeansXmlUrl = this.getBeanXmlUrl(archive, "/WEB-INF/classes/META-INF/beans.xml")) != null) {
            this.beansXmls.add(metainfBeansXmlUrl);
        }
        if (metainfBeansXmlUrl != null || webBeansXmlUrl != null) {
            BeanArchiveService.BeanArchiveInformation info = this.archiveService.getBeanArchiveInformation(webBeansXmlUrl != null ? webBeansXmlUrl : metainfBeansXmlUrl);
            Map classes = archive.getContent(Filters.include((String)"/WEB-INF/classes/.*\\.class"));
            this.scanClasses(info, classes, WEB_INF_CLASS_FOLDER);
        }
        Map jars = archive.getContent(Filters.include((String)"/WEB-INF/lib/.*\\.jar"));
        for (Map.Entry jarEntry : jars.entrySet()) {
            FileAsset fileAsset;
            Asset asset = ((Node)jarEntry.getValue()).getAsset();
            if (asset instanceof FileAsset && (fileAsset = (FileAsset)asset).getSource().getName().endsWith(".jar")) {
                Archive fileArchive = (Archive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)fileAsset.getSource());
                asset = new ArchiveAsset(fileArchive, ZipExporter.class);
            }
            if (!(asset instanceof ArchiveAsset)) continue;
            ArchiveAsset archiveAsset = (ArchiveAsset)asset;
            JavaArchive jarArchive = (JavaArchive)archiveAsset.getArchive();
            this.scanJarArchive((Archive<?>)jarArchive);
        }
    }

    private void scanJarArchive(Archive<?> archive) {
        URL beansXmlUrl = this.getBeanXmlUrl(archive, "META-INF/beans.xml");
        if (beansXmlUrl == null) {
            return;
        }
        this.beansXmls.add(beansXmlUrl);
        Map classes = archive.getContent(Filters.include((String)".*\\.class"));
        this.scanClasses(this.archiveService.getBeanArchiveInformation(beansXmlUrl), classes, null);
    }

    private void scanClasses(BeanArchiveService.BeanArchiveInformation info, Map<ArchivePath, Node> classes, String classBasePath) {
        for (Map.Entry<ArchivePath, Node> classEntry : classes.entrySet()) {
            String className = classEntry.getKey().get();
            if (classBasePath != null && className.startsWith(WEB_INF_CLASS_FOLDER)) {
                className = className.substring(WEB_INF_CLASS_FOLDER.length());
            }
            if (className.startsWith("/")) {
                className = className.substring(1);
            }
            className = className.substring(0, className.length() - ".class".length());
            className = className.replace('/', '.');
            if (info != null && info.isClassExcluded(className)) continue;
            try {
                Class<?> beanClass = Class.forName(className);
                this.beanClasses.add(beanClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not scan class", cnfe);
            }
        }
    }

    private URL getBeanXmlUrl(Archive archive, String beansXmlPath) {
        final Node beansXml = archive.get(beansXmlPath);
        if (beansXml == null) {
            return null;
        }
        try {
            String urlLocation = "archive://" + archive.getName() + "/" + beansXmlPath;
            return new URL(null, urlLocation, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return beansXml.getAsset().openStream();
                        }
                    };
                }
            });
        }
        catch (Exception e) {
            RuntimeException runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException("Error while parsing beans.xml location", e);
            throw runtimeException;
        }
    }

    public void clear() {
        this.archive = null;
        this.beansXmls = new UrlSet();
        this.beanClasses = new HashSet();
    }
}

