/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.monitoring;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import opennlp.tools.monitoring.StopCriteria;
import opennlp.tools.monitoring.TrainingMeasure;
import opennlp.tools.monitoring.TrainingProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrainingProgressMonitor
implements TrainingProgressMonitor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTrainingProgressMonitor.class);
    private volatile boolean isTrainingFinished;
    private final List<String> progress = new LinkedList<String>();

    @Override
    public synchronized void finishedIteration(int iteration, int numberCorrectEvents, int totalEvents, TrainingMeasure measure, double measureValue) {
        this.progress.add(String.format("%s: (%s/%s) %s : %s", iteration, numberCorrectEvents, totalEvents, measure.getMeasureName(), measureValue));
    }

    @Override
    public synchronized void finishedTraining(int iterations, StopCriteria<?> stopCriteria) {
        if (!Objects.isNull(stopCriteria)) {
            this.progress.add(stopCriteria.getMessageIfSatisfied());
        } else {
            this.progress.add(String.format("Training finished after completing %s iterations successfully.", iterations));
        }
        this.isTrainingFinished = true;
    }

    @Override
    public synchronized void display(boolean clear) {
        this.progress.stream().forEach(arg_0 -> ((Logger)logger).info(arg_0));
        if (clear) {
            this.progress.clear();
        }
    }

    @Override
    public boolean isTrainingFinished() {
        return this.isTrainingFinished;
    }
}

