/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import opennlp.tools.util.wordvector.AbstractWordVectorTest;
import opennlp.tools.util.wordvector.FloatArrayVector;
import opennlp.tools.util.wordvector.Glove;
import opennlp.tools.util.wordvector.WordVector;
import opennlp.tools.util.wordvector.WordVectorTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MapWordVectorTableTest
extends AbstractWordVectorTest {
    private WordVectorTable wvTable;

    @BeforeEach
    public void setup() throws IOException {
        try (InputStream glove = this.getResourceStream("glove-example-short.txt");){
            this.wvTable = Glove.parse((InputStream)glove);
            Assertions.assertNotNull((Object)this.wvTable);
        }
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((float)4.0f, (float)this.wvTable.size());
    }

    @Test
    public void testDimension() {
        Assertions.assertEquals((float)50.0f, (float)this.wvTable.dimension());
    }

    @Test
    public void testTokens() {
        Set<String> refTokens = Set.of("the", "of", "to", "and");
        Iterator tokens = this.wvTable.tokens();
        Assertions.assertNotNull((Object)tokens);
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            Assertions.assertTrue((boolean)refTokens.contains(token));
        }
    }

    @Test
    public void testGetWordVectors() {
        Set<String> refTokens = Set.of("the", "of", "to", "and");
        for (String token : refTokens) {
            WordVector wv = this.wvTable.get(token);
            Assertions.assertNotNull((Object)wv);
            Assertions.assertEquals((float)50.0f, (float)wv.dimension());
        }
    }

    @Test
    public void testGetWordVectorEquality() {
        float[] wordVectorOfThe = new float[]{0.418f, 0.24968f, -0.41242f, 0.1217f, 0.34527f, -0.044457f, -0.49688f, -0.17862f, -6.6023E-4f, -0.6566f, 0.27843f, -0.14767f, -0.55677f, 0.14658f, -0.0095095f, 0.011658f, 0.10204f, -0.12792f, -0.8443f, -0.12181f, -0.016801f, -0.33279f, -0.1552f, -0.23131f, -0.19181f, -1.8823f, -0.76746f, 0.099051f, -0.42125f, -0.19526f, 4.0071f, -0.18594f, -0.52287f, -0.31681f, 5.9213E-4f, 0.0074449f, 0.17778f, -0.15897f, 0.012041f, -0.054223f, -0.29871f, -0.15749f, -0.34758f, -0.045637f, -0.44251f, 0.18785f, 0.0027849f, -0.18411f, -0.11514f, -0.78581f};
        FloatArrayVector refWordVector = new FloatArrayVector(wordVectorOfThe);
        WordVector wv = this.wvTable.get("the");
        Assertions.assertNotNull((Object)wv);
        for (int i = 0; i < wordVectorOfThe.length; ++i) {
            Assertions.assertEquals((float)refWordVector.getAsFloat(i), (float)wv.getAsFloat(i));
        }
    }
}

