/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.util.wordvector.AbstractWordVectorTest;
import opennlp.tools.util.wordvector.Glove;
import opennlp.tools.util.wordvector.WordVectorTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GloveTest
extends AbstractWordVectorTest {
    @Test
    public void testParseValid() throws IOException {
        try (InputStream glove = this.getResourceStream("glove-example-short.txt");){
            WordVectorTable wvTable = Glove.parse((InputStream)glove);
            Assertions.assertNotNull((Object)wvTable);
            Assertions.assertNotNull((Object)wvTable.get("the"));
            Assertions.assertNotNull((Object)wvTable.get("of"));
            Assertions.assertNotNull((Object)wvTable.get("to"));
            Assertions.assertNotNull((Object)wvTable.get("and"));
            Assertions.assertNull((Object)wvTable.get("OpenNLP"));
        }
    }

    @Test
    public void testParseEmpty() throws IOException {
        try (InputStream glove = this.getResourceStream("glove-example-empty.txt");){
            WordVectorTable wvTable = Glove.parse((InputStream)glove);
            Assertions.assertNotNull((Object)wvTable);
            Assertions.assertEquals((int)-1, (int)wvTable.dimension());
        }
    }

    @Test
    public void testParseDetectsBrokenDimensions() throws IOException {
        try (InputStream glove = this.getResourceStream("glove-example-broken-dimensions.txt");){
            Assertions.assertThrows(IOException.class, () -> Glove.parse((InputStream)glove));
        }
    }
}

