/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import opennlp.tools.util.wordvector.FloatArrayVector;
import opennlp.tools.util.wordvector.WordVectorType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FloatArrayVectorTest {
    private float[] floatArray;

    @BeforeEach
    public void setup() {
        this.floatArray = new float[]{Float.MIN_VALUE, -1.0f, 0.0f, 1.0f, Float.MAX_VALUE};
    }

    @AfterEach
    public void tearDown() {
        this.floatArray = null;
    }

    @Test
    public void testGetDataType() {
        FloatArrayVector faVector = new FloatArrayVector(this.floatArray);
        Assertions.assertEquals((Object)WordVectorType.FLOAT, (Object)faVector.getDataType());
    }

    @Test
    public void testGetDimension() {
        FloatArrayVector faVector = new FloatArrayVector(this.floatArray);
        Assertions.assertEquals((int)this.floatArray.length, (int)faVector.dimension());
    }

    @Test
    public void testGetAsFloat() {
        FloatArrayVector faVector = new FloatArrayVector(this.floatArray);
        for (int i = 0; i < faVector.dimension(); ++i) {
            Assertions.assertEquals((float)this.floatArray[i], (float)faVector.getAsFloat(i));
        }
    }

    @Test
    public void testGetAsDouble() {
        FloatArrayVector faVector = new FloatArrayVector(this.floatArray);
        for (int i = 0; i < faVector.dimension(); ++i) {
            Assertions.assertEquals((double)this.floatArray[i], (double)faVector.getAsDouble(i));
        }
    }

    @Test
    public void testToFloatBuffer() {
        FloatBuffer refBuffer = FloatBuffer.wrap(this.floatArray);
        FloatArrayVector faVector = new FloatArrayVector(this.floatArray);
        FloatBuffer fBuffer = faVector.toFloatBuffer();
        Assertions.assertNotNull((Object)fBuffer);
        Assertions.assertEquals((int)0, (int)refBuffer.compareTo(fBuffer));
    }

    @Test
    public void testToDoubleBuffer() {
        double[] doubleArray = new double[]{1.4E-45f, -1.0, 0.0, 1.0, 3.4028234663852886E38};
        DoubleBuffer refBuffer = DoubleBuffer.wrap(doubleArray);
        FloatArrayVector faVector = new FloatArrayVector(this.floatArray);
        DoubleBuffer dBuffer = faVector.toDoubleBuffer();
        Assertions.assertNotNull((Object)dBuffer);
        Assertions.assertEquals((int)0, (int)refBuffer.compareTo(dBuffer));
    }
}

