/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import opennlp.tools.util.wordvector.DoubleArrayVector;
import opennlp.tools.util.wordvector.WordVectorType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DoubleArrayVectorTest {
    private double[] doubleArray;

    @BeforeEach
    public void setup() {
        this.doubleArray = new double[]{1.4E-45f, -1.0, 0.0, 1.0, 3.4028234663852886E38};
    }

    @AfterEach
    public void tearDown() {
        this.doubleArray = null;
    }

    @Test
    public void testGetDataType() {
        DoubleArrayVector faVector = new DoubleArrayVector(this.doubleArray);
        Assertions.assertEquals((Object)WordVectorType.DOUBLE, (Object)faVector.getDataType());
    }

    @Test
    public void testGetDimension() {
        DoubleArrayVector faVector = new DoubleArrayVector(this.doubleArray);
        Assertions.assertEquals((int)this.doubleArray.length, (int)faVector.dimension());
    }

    @Test
    public void testGetAsFloat() {
        DoubleArrayVector faVector = new DoubleArrayVector(this.doubleArray);
        for (int i = 0; i < faVector.dimension(); ++i) {
            Assertions.assertEquals((double)this.doubleArray[i], (double)faVector.getAsFloat(i));
        }
    }

    @Test
    public void testGetAsDouble() {
        DoubleArrayVector faVector = new DoubleArrayVector(this.doubleArray);
        for (int i = 0; i < faVector.dimension(); ++i) {
            Assertions.assertEquals((double)this.doubleArray[i], (double)faVector.getAsDouble(i));
        }
    }

    @Test
    public void testToFloatBuffer() {
        float[] floatArray = new float[]{Float.MIN_VALUE, -1.0f, 0.0f, 1.0f, Float.MAX_VALUE};
        FloatBuffer refBuffer = FloatBuffer.wrap(floatArray);
        DoubleArrayVector daVector = new DoubleArrayVector(this.doubleArray);
        FloatBuffer fBuffer = daVector.toFloatBuffer();
        Assertions.assertNotNull((Object)fBuffer);
        Assertions.assertEquals((int)0, (int)refBuffer.compareTo(fBuffer));
    }

    @Test
    public void testToDoubleBuffer() {
        DoubleBuffer refBuffer = DoubleBuffer.wrap(this.doubleArray);
        DoubleArrayVector daVector = new DoubleArrayVector(this.doubleArray);
        DoubleBuffer dBuffer = daVector.toDoubleBuffer();
        Assertions.assertNotNull((Object)dBuffer);
        Assertions.assertEquals((int)0, (int)refBuffer.compareTo(dBuffer));
    }
}

