/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.normalizer;

import opennlp.tools.util.normalizer.TwitterCharSequenceNormalizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TwitterCharSequenceNormalizerTest {
    private final TwitterCharSequenceNormalizer normalizer = TwitterCharSequenceNormalizer.getInstance();

    @Test
    void normalizeHashtag() {
        Assertions.assertEquals((Object)"asdf   2nnfdf", (Object)this.normalizer.normalize((CharSequence)"asdf #hasdk23 2nnfdf"));
    }

    @Test
    void normalizeUser() {
        Assertions.assertEquals((Object)"asdf   2nnfdf", (Object)this.normalizer.normalize((CharSequence)"asdf @hasdk23 2nnfdf"));
    }

    @Test
    void normalizeRT() {
        Assertions.assertEquals((Object)" 2nnfdf", (Object)this.normalizer.normalize((CharSequence)"RT RT RT 2nnfdf"));
    }

    @Test
    void normalizeLaugh() {
        Assertions.assertEquals((Object)"ahahah", (Object)this.normalizer.normalize((CharSequence)"ahahahah"));
        Assertions.assertEquals((Object)"haha", (Object)this.normalizer.normalize((CharSequence)"hahha"));
        Assertions.assertEquals((Object)"haha", (Object)this.normalizer.normalize((CharSequence)"hahaa"));
        Assertions.assertEquals((Object)"ahaha", (Object)this.normalizer.normalize((CharSequence)"ahahahahhahahhahahaaaa"));
        Assertions.assertEquals((Object)"jaja", (Object)this.normalizer.normalize((CharSequence)"jajjajajaja"));
    }

    @Test
    void normalizeFace() {
        Assertions.assertEquals((Object)"hello   hello", (Object)this.normalizer.normalize((CharSequence)"hello :-) hello"));
        Assertions.assertEquals((Object)"hello   hello", (Object)this.normalizer.normalize((CharSequence)"hello ;) hello"));
        Assertions.assertEquals((Object)"  hello", (Object)this.normalizer.normalize((CharSequence)":) hello"));
        Assertions.assertEquals((Object)"hello  ", (Object)this.normalizer.normalize((CharSequence)"hello :P"));
    }
}

