/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.IdentityFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WindowFeatureGeneratorTest {
    private final String[] testSentence = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
    private List<String> features;

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testWithoutWindow() {
        WindowFeatureGenerator windowFeatureGenerator = new WindowFeatureGenerator((AdaptiveFeatureGenerator)new IdentityFeatureGenerator(), 0, 0);
        int testTokenIndex = 2;
        windowFeatureGenerator.createFeatures(this.features, this.testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"c", (Object)this.features.get(0));
    }

    @Test
    void testWindowSizeOne() {
        WindowFeatureGenerator windowFeatureGenerator = new WindowFeatureGenerator((AdaptiveFeatureGenerator)new IdentityFeatureGenerator(), 1, 1);
        int testTokenIndex = 2;
        windowFeatureGenerator.createFeatures(this.features, this.testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)3, (int)this.features.size());
        Assertions.assertEquals((Object)"c", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"p1b", (Object)this.features.get(1));
        Assertions.assertEquals((Object)"n1d", (Object)this.features.get(2));
    }

    @Test
    void testWindowAtBeginOfSentence() {
        WindowFeatureGenerator windowFeatureGenerator = new WindowFeatureGenerator((AdaptiveFeatureGenerator)new IdentityFeatureGenerator(), 1, 0);
        int testTokenIndex = 0;
        windowFeatureGenerator.createFeatures(this.features, this.testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"a", (Object)this.features.get(0));
    }

    @Test
    void testWindowAtEndOfSentence() {
        WindowFeatureGenerator windowFeatureGenerator = new WindowFeatureGenerator((AdaptiveFeatureGenerator)new IdentityFeatureGenerator(), 0, 1);
        int testTokenIndex = this.testSentence.length - 1;
        windowFeatureGenerator.createFeatures(this.features, this.testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"h", (Object)this.features.get(0));
    }

    @Test
    void testForCorrectFeatures() {
        WindowFeatureGenerator windowFeatureGenerator = new WindowFeatureGenerator((AdaptiveFeatureGenerator)new IdentityFeatureGenerator(), 2, 2);
        int testTokenIndex = 3;
        windowFeatureGenerator.createFeatures(this.features, this.testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)5, (int)this.features.size());
        Assertions.assertEquals((Object)"d", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"p1c", (Object)this.features.get(1));
        Assertions.assertEquals((Object)"p2b", (Object)this.features.get(2));
        Assertions.assertEquals((Object)"n1e", (Object)this.features.get(3));
        Assertions.assertEquals((Object)"n2f", (Object)this.features.get(4));
    }
}

