/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.TrigramNameFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TrigramNameFeatureGeneratorTest {
    private List<String> features;
    private static final String[] TEST_SENTENCE = new String[]{"This", "is", "an", "example", "sentence"};

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testBegin() {
        boolean testTokenIndex = false;
        TrigramNameFeatureGenerator generator = new TrigramNameFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 0, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"w,nw,nnw=This,is,an", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"wc,nwc,nnwc=ic,lc,lc", (Object)this.features.get(1));
    }

    @Test
    void testNextOfBegin() {
        boolean testTokenIndex = true;
        TrigramNameFeatureGenerator generator = new TrigramNameFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 1, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"w,nw,nnw=is,an,example", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"wc,nwc,nnwc=lc,lc,lc", (Object)this.features.get(1));
    }

    @Test
    void testMiddle() {
        int testTokenIndex = 2;
        TrigramNameFeatureGenerator generator = new TrigramNameFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 2, null);
        Assertions.assertEquals((int)4, (int)this.features.size());
        Assertions.assertEquals((Object)"ppw,pw,w=This,is,an", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"ppwc,pwc,wc=ic,lc,lc", (Object)this.features.get(1));
        Assertions.assertEquals((Object)"w,nw,nnw=an,example,sentence", (Object)this.features.get(2));
        Assertions.assertEquals((Object)"wc,nwc,nnwc=lc,lc,lc", (Object)this.features.get(3));
    }

    @Test
    void testEnd() {
        int testTokenIndex = 4;
        TrigramNameFeatureGenerator generator = new TrigramNameFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 4, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"ppw,pw,w=an,example,sentence", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"ppwc,pwc,wc=lc,lc,lc", (Object)this.features.get(1));
    }

    @Test
    void testShort() {
        String[] shortSentence = new String[]{"I", "know", "it"};
        boolean testTokenIndex = true;
        TrigramNameFeatureGenerator generator = new TrigramNameFeatureGenerator();
        generator.createFeatures(this.features, shortSentence, 1, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
    }
}

