/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.TokenPatternFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TokenPatternFeatureGeneratorTest {
    private List<String> features;

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testSingleToken() {
        String[] testSentence = new String[]{"This", "is", "an", "example", "sentence"};
        int testTokenIndex = 3;
        TokenPatternFeatureGenerator generator = new TokenPatternFeatureGenerator();
        generator.createFeatures(this.features, testSentence, 3, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"st=example", (Object)this.features.get(0));
    }

    @Test
    void testSentence() {
        String[] testSentence = new String[]{"This is an example sentence"};
        boolean testTokenIndex = false;
        TokenPatternFeatureGenerator generator = new TokenPatternFeatureGenerator();
        generator.createFeatures(this.features, testSentence, 0, null);
        Assertions.assertEquals((int)14, (int)this.features.size());
        Assertions.assertEquals((Object)"stn=5", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"pt2=iclc", (Object)this.features.get(1));
        Assertions.assertEquals((Object)"pt3=iclclc", (Object)this.features.get(2));
        Assertions.assertEquals((Object)"st=this", (Object)this.features.get(3));
        Assertions.assertEquals((Object)"pt2=lclc", (Object)this.features.get(4));
        Assertions.assertEquals((Object)"pt3=lclclc", (Object)this.features.get(5));
        Assertions.assertEquals((Object)"st=is", (Object)this.features.get(6));
        Assertions.assertEquals((Object)"pt2=lclc", (Object)this.features.get(7));
        Assertions.assertEquals((Object)"pt3=lclclc", (Object)this.features.get(8));
        Assertions.assertEquals((Object)"st=an", (Object)this.features.get(9));
        Assertions.assertEquals((Object)"pt2=lclc", (Object)this.features.get(10));
        Assertions.assertEquals((Object)"st=example", (Object)this.features.get(11));
        Assertions.assertEquals((Object)"st=sentence", (Object)this.features.get(12));
        Assertions.assertEquals((Object)"pta=iclclclclc", (Object)this.features.get(13));
    }
}

