/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TokenClassFeatureGeneratorTest {
    private List<String> features;
    private static final String[] TEST_SENTENCE = new String[]{"This", "is", "an", "Example", "sentence"};

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testGenWAC() {
        int testTokenIndex = 3;
        TokenClassFeatureGenerator generator = new TokenClassFeatureGenerator(true);
        generator.createFeatures(this.features, TEST_SENTENCE, 3, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"wc=ic", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"w&c=example,ic", (Object)this.features.get(1));
    }

    @Test
    void testNoWAC() {
        int testTokenIndex = 3;
        TokenClassFeatureGenerator generator = new TokenClassFeatureGenerator(false);
        generator.createFeatures(this.features, TEST_SENTENCE, 3, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"wc=ic", (Object)this.features.get(0));
    }
}

