/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.SuffixFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SuffixFeatureGeneratorTest {
    private List<String> features;

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void lengthTest1() {
        String[] testSentence = new String[]{"This", "is", "an", "example", "sentence"};
        int testTokenIndex = 0;
        int suffixLength = 2;
        SuffixFeatureGenerator generator = new SuffixFeatureGenerator(suffixLength);
        generator.createFeatures(this.features, testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"suf=s", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"suf=is", (Object)this.features.get(1));
    }

    @Test
    void lengthTest2() {
        String[] testSentence = new String[]{"This", "is", "an", "example", "sentence"};
        int testTokenIndex = 3;
        int suffixLength = 5;
        SuffixFeatureGenerator generator = new SuffixFeatureGenerator(suffixLength);
        generator.createFeatures(this.features, testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)5, (int)this.features.size());
        Assertions.assertEquals((Object)"suf=e", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"suf=le", (Object)this.features.get(1));
        Assertions.assertEquals((Object)"suf=ple", (Object)this.features.get(2));
        Assertions.assertEquals((Object)"suf=mple", (Object)this.features.get(3));
        Assertions.assertEquals((Object)"suf=ample", (Object)this.features.get(4));
    }

    @Test
    void lengthTest3() {
        String[] testSentence = new String[]{"This", "is", "an", "example", "sentence"};
        int testTokenIndex = 1;
        int suffixLength = 5;
        SuffixFeatureGenerator generator = new SuffixFeatureGenerator(suffixLength);
        generator.createFeatures(this.features, testSentence, testTokenIndex, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"suf=s", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"suf=is", (Object)this.features.get(1));
    }
}

