/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import opennlp.tools.util.featuregen.StringPattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringPatternTest {
    @Test
    void testIsAllLetters() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test").isAllLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"TEST").isAllLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"TesT").isAllLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"gr\u00fcn").isAllLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u00fc\u00e4\u00f6\u00e6\u00df").isAllLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u3042\u30a2\u4e9c\uff21\uff41").isAllLetter());
    }

    @Test
    void testIsInitialCapitalLetter() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"Test").isInitialCapitalLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"tEST").isInitialCapitalLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"TesT").isInitialCapitalLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u00dc\u00e4\u00f6\u00e6\u00df").isInitialCapitalLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u3044\u30a4\u4e95").isInitialCapitalLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"I\u3044\u30a4\u4e95").isInitialCapitalLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\uff29\u3044\u30a4\u4e95").isInitialCapitalLetter());
    }

    @Test
    void testIsAllCapitalLetter() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"TEST").isAllCapitalLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u00c4\u00c4\u00c4\u00dc\u00dc\u00dc\u00d6\u00d6\u00d6\u00d6").isAllCapitalLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u00c4\u00c4\u00c4\u00dc\u00dc\u00dc\u00d6\u00d6\u00e4").isAllCapitalLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u00c4\u00c4\u00c4\u00dc\u00dcd\u00dc\u00d6\u00d6").isAllCapitalLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\uff21\uff22\uff23").isAllCapitalLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u3046\u30a6\u5b87").isAllCapitalLetter());
    }

    @Test
    void testIsAllLowerCaseLetter() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test").isAllLowerCaseLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u00f6\u00e4\u00fc").isAllLowerCaseLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u00f6\u00e4\u00fc\u00df\u00df\u00df").isAllLowerCaseLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"Test").isAllLowerCaseLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"TEST").isAllLowerCaseLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"testT").isAllLowerCaseLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"tes\u00d6t").isAllLowerCaseLetter());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\uff41\uff42\uff43").isAllLowerCaseLetter());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u3048\u30a8\u7d75").isAllLowerCaseLetter());
    }

    @Test
    void testIsAllDigit() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"123456").isAllDigit());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"123,56").isAllDigit());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"12356f").isAllDigit());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\uff11\uff12\uff13\uff14\uff15\uff16").isAllDigit());
    }

    @Test
    void testIsAllHiragana() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u3042\u3071\u3063\u3061\u30fb\u308b\u3057\u30fc\u3093").isAllHiragana());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u3042\u3071\u3063\u3061\u30fb\u305d\u3075\u3068\u3046\u3047\u3042\u8ca1\u56e3").isAllHiragana());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u3042\u3071\u3063\u3061\u30fb\u308b\u3057\u30fc\u3093\uff36\uff11\uff0e\uff10").isAllHiragana());
    }

    @Test
    void testIsAllKatakana() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u30a2\u30d1\u30c3\u30c1\u30fb\u30eb\u30b7\u30fc\u30f3").isAllKatakana());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u30a2\u30d1\u30c3\u30c1\u30fb\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u8ca1\u56e3").isAllKatakana());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u30a2\u30d1\u30c3\u30c1\u30fb\u30eb\u30b7\u30fc\u30f3\uff36\uff11\uff0e\uff10").isAllKatakana());
    }

    @Test
    void testDigits() {
        Assertions.assertEquals((int)6, (int)StringPattern.recognize((String)"123456").digits());
        Assertions.assertEquals((int)3, (int)StringPattern.recognize((String)"123fff").digits());
        Assertions.assertEquals((int)0, (int)StringPattern.recognize((String)"test").digits());
        Assertions.assertEquals((int)3, (int)StringPattern.recognize((String)"\uff11\uff12\uff13\uff46\uff46\uff46").digits());
    }

    @Test
    void testContainsPeriod() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test.").containsPeriod());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"23.5").containsPeriod());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"test,/-1").containsPeriod());
    }

    @Test
    void testContainsComma() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test,").containsComma());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"23,5").containsComma());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"test./-1").containsComma());
    }

    @Test
    void testContainsSlash() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test/").containsSlash());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"23/5").containsSlash());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"test.1-,").containsSlash());
    }

    @Test
    void testContainsDigit() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test1").containsDigit());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"23,5").containsDigit());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"test./-,").containsDigit());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"\u30c6\u30b9\u30c8\uff11").containsDigit());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"\u30c6\u30b9\u30c8\uff34\uff25\uff33\uff34").containsDigit());
    }

    @Test
    void testContainsHyphen() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test--").containsHyphen());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"23-5").containsHyphen());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"test.1/,").containsHyphen());
    }

    @Test
    void testContainsLetters() {
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"test--").containsLetters());
        Assertions.assertTrue((boolean)StringPattern.recognize((String)"23h5\u00dfm").containsLetters());
        Assertions.assertFalse((boolean)StringPattern.recognize((String)"---.1/,").containsLetters());
    }
}

