/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.SentenceFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SentenceFeatureGeneratorTest {
    private List<String> features;
    private static final String[] TEST_SENTENCE = new String[]{"This", "is", "an", "example", "sentence"};
    private static final String[] TEST_SHORT = new String[]{"word"};

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testTT() {
        SentenceFeatureGenerator generator = new SentenceFeatureGenerator(true, true);
        generator.createFeatures(this.features, TEST_SENTENCE, 2, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        generator.createFeatures(this.features, TEST_SENTENCE, 0, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"S=begin", (Object)this.features.get(0));
        this.features.clear();
        generator.createFeatures(this.features, TEST_SENTENCE, TEST_SENTENCE.length - 1, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"S=end", (Object)this.features.get(0));
        this.features.clear();
        generator.createFeatures(this.features, TEST_SHORT, 0, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"S=begin", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"S=end", (Object)this.features.get(1));
    }

    @Test
    void testTF() {
        SentenceFeatureGenerator generator = new SentenceFeatureGenerator(true, false);
        generator.createFeatures(this.features, TEST_SENTENCE, 2, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        generator.createFeatures(this.features, TEST_SENTENCE, 0, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"S=begin", (Object)this.features.get(0));
        this.features.clear();
        generator.createFeatures(this.features, TEST_SENTENCE, TEST_SENTENCE.length - 1, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        this.features.clear();
        generator.createFeatures(this.features, TEST_SHORT, 0, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"S=begin", (Object)this.features.get(0));
    }

    @Test
    void testFT() {
        SentenceFeatureGenerator generator = new SentenceFeatureGenerator(false, true);
        generator.createFeatures(this.features, TEST_SENTENCE, 2, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        generator.createFeatures(this.features, TEST_SENTENCE, 0, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        generator.createFeatures(this.features, TEST_SENTENCE, TEST_SENTENCE.length - 1, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"S=end", (Object)this.features.get(0));
        this.features.clear();
        generator.createFeatures(this.features, TEST_SHORT, 0, null);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"S=end", (Object)this.features.get(0));
    }

    @Test
    void testFF() {
        SentenceFeatureGenerator generator = new SentenceFeatureGenerator(false, false);
        generator.createFeatures(this.features, TEST_SENTENCE, 2, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        generator.createFeatures(this.features, TEST_SENTENCE, 0, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        generator.createFeatures(this.features, TEST_SENTENCE, TEST_SENTENCE.length - 1, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
        generator.createFeatures(this.features, TEST_SHORT, 0, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
    }
}

