/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.PosTaggerFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PosTaggerFeatureGeneratorTest {
    private List<String> features;
    private static final String[] TEST_SENTENCE = new String[]{"This", "is", "an", "example", "sentence"};
    private static final String[] TEST_TAGS = new String[]{"DT", "VBZ", "DT", "NN", "NN"};

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testBegin() {
        boolean testTokenIndex = false;
        PosTaggerFeatureGenerator generator = new PosTaggerFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 0, TEST_TAGS);
        Assertions.assertEquals((int)0, (int)this.features.size());
    }

    @Test
    void testNext() {
        boolean testTokenIndex = true;
        PosTaggerFeatureGenerator generator = new PosTaggerFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 1, TEST_TAGS);
        Assertions.assertEquals((int)1, (int)this.features.size());
        Assertions.assertEquals((Object)"t=DT", (Object)this.features.get(0));
    }

    @Test
    void testMiddle() {
        int testTokenIndex = 3;
        PosTaggerFeatureGenerator generator = new PosTaggerFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 3, TEST_TAGS);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"t=DT", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"t2=VBZ,DT", (Object)this.features.get(1));
    }
}

