/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;
import opennlp.tools.util.featuregen.InSpanGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InSpanGeneratorTest {
    @Test
    void test() {
        ArrayList features = new ArrayList();
        String[] testSentence = new String[]{"Every", "John", "has", "its", "day", "."};
        InSpanGenerator generator = new InSpanGenerator("john", (TokenNameFinder)new SimpleSpecificPersonFinder("John"));
        generator.createFeatures(features, testSentence, 0, null);
        Assertions.assertEquals((int)0, (int)features.size());
        features.clear();
        generator.createFeatures(features, testSentence, 1, null);
        Assertions.assertEquals((int)2, (int)features.size());
        Assertions.assertEquals((Object)"john:w=dic", features.get(0));
        Assertions.assertEquals((Object)"john:w=dic=John", features.get(1));
    }

    static class SimpleSpecificPersonFinder
    implements TokenNameFinder {
        private final String theName;

        public SimpleSpecificPersonFinder(String theName) {
            this.theName = theName;
        }

        public Span[] find(String[] tokens) {
            for (int i = 0; i < tokens.length; ++i) {
                if (!this.theName.equals(tokens[i])) continue;
                return new Span[]{new Span(i, i + 1, "person")};
            }
            return new Span[0];
        }

        public void clearAdaptiveData() {
        }
    }
}

