/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.DictionaryFeatureGenerator;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.DictionarySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeneratorFactoryTest {
    @Test
    void testCreationWithUnkownElement() {
        Assertions.assertThrows(IOException.class, () -> {
            try (InputStream descIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/FeatureGeneratorConfigWithUnkownElement.xml");){
                GeneratorFactory.create((InputStream)descIn, null);
            }
        });
    }

    @Test
    void testCreationWithTokenClassFeatureGenerator() throws Exception {
        InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestTokenClassFeatureGeneratorConfig.xml");
        Assertions.assertNotNull((Object)generatorDescriptorIn);
        AggregatedFeatureGenerator aggregatedGenerator = (AggregatedFeatureGenerator)GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
        Assertions.assertEquals((int)1, (int)aggregatedGenerator.getGenerators().size());
        Assertions.assertEquals((Object)TokenClassFeatureGenerator.class.getName(), (Object)((AdaptiveFeatureGenerator)aggregatedGenerator.getGenerators().iterator().next()).getClass().getName());
    }

    @Test
    void testCreationWihtSimpleDescriptor() throws Exception {
        try (InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestFeatureGeneratorConfig.xml");){
            Assertions.assertNotNull((Object)generatorDescriptorIn);
            ArrayList<String> expectedGenerators = new ArrayList<String>();
            expectedGenerators.add(OutcomePriorFeatureGenerator.class.getName());
            AggregatedFeatureGenerator aggregatedGenerator = (AggregatedFeatureGenerator)GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
            for (AdaptiveFeatureGenerator generator : aggregatedGenerator.getGenerators()) {
                expectedGenerators.remove(generator.getClass().getName());
            }
            Assertions.assertEquals((int)0, (int)expectedGenerators.size());
        }
    }

    @Test
    void testCreationWithDictionaryFeatureGenerator() throws IOException {
        try (InputStream descIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestDictionarySerializerMappingExtraction.xml");){
            AdaptiveFeatureGenerator generator = GeneratorFactory.create((InputStream)descIn, null);
            Assertions.assertInstanceOf(DictionaryFeatureGenerator.class, (Object)((CachedFeatureGenerator)generator).getCachedFeatureGenerator());
        }
    }

    @Test
    void testDictionaryArtifactToSerializerMappingExtraction() throws IOException {
        try (InputStream descIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestDictionarySerializerMappingExtraction.xml");){
            Map mapping = GeneratorFactory.extractArtifactSerializerMappings((InputStream)descIn);
            Assertions.assertNotNull((Object)mapping);
            Assertions.assertEquals((int)1, (int)mapping.size());
            ArtifactSerializer result = (ArtifactSerializer)mapping.get("opennlp/tools/util/featuregen/DictionaryTest.xml");
            Assertions.assertInstanceOf(DictionarySerializer.class, (Object)result);
        }
    }

    @Test
    void testParameters() throws Exception {
        InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestParametersConfig.xml");
        Assertions.assertNotNull((Object)generatorDescriptorIn);
        AdaptiveFeatureGenerator generator = GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
        Assertions.assertInstanceOf(TestParametersFeatureGenerator.class, (Object)generator);
        TestParametersFeatureGenerator featureGenerator = (TestParametersFeatureGenerator)generator;
        Assertions.assertEquals((int)123, (int)featureGenerator.ip);
        Assertions.assertEquals((double)0.1, (double)featureGenerator.fp, (double)45.0);
        Assertions.assertEquals((long)67890L, (long)featureGenerator.lp);
        Assertions.assertEquals((double)0.1, (double)featureGenerator.dp, (double)123456.789);
        Assertions.assertTrue((boolean)featureGenerator.bp);
        Assertions.assertEquals((Object)"HELLO", (Object)featureGenerator.sp);
    }

    @Test
    void testNotAutomaticallyInsertAggregatedFeatureGenerator() throws Exception {
        InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestNotAutomaticallyInsertAggregatedFeatureGenerator.xml");
        Assertions.assertNotNull((Object)generatorDescriptorIn);
        AdaptiveFeatureGenerator featureGenerator = GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
        Assertions.assertInstanceOf(OutcomePriorFeatureGenerator.class, (Object)featureGenerator);
    }

    @Test
    void testAutomaticallyInsertAggregatedFeatureGenerator() throws Exception {
        InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestAutomaticallyInsertAggregatedFeatureGenerator.xml");
        Assertions.assertNotNull((Object)generatorDescriptorIn);
        AdaptiveFeatureGenerator featureGenerator = GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
        Assertions.assertInstanceOf(AggregatedFeatureGenerator.class, (Object)featureGenerator);
        AggregatedFeatureGenerator aggregatedFeatureGenerator = (AggregatedFeatureGenerator)featureGenerator;
        Assertions.assertEquals((int)3, (int)aggregatedFeatureGenerator.getGenerators().size());
        for (AdaptiveFeatureGenerator afg : aggregatedFeatureGenerator.getGenerators()) {
            Assertions.assertInstanceOf(OutcomePriorFeatureGenerator.class, (Object)afg);
        }
    }

    @Test
    void testNotAutomaticallyInsertAggregatedFeatureGeneratorChild() throws Exception {
        InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestNotAutomaticallyInsertAggregatedFeatureGeneratorCache.xml");
        Assertions.assertNotNull((Object)generatorDescriptorIn);
        AdaptiveFeatureGenerator featureGenerator = GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
        Assertions.assertInstanceOf(CachedFeatureGenerator.class, (Object)featureGenerator);
        CachedFeatureGenerator cachedFeatureGenerator = (CachedFeatureGenerator)featureGenerator;
        Assertions.assertInstanceOf(OutcomePriorFeatureGenerator.class, (Object)cachedFeatureGenerator.getCachedFeatureGenerator());
    }

    @Test
    void testAutomaticallyInsertAggregatedFeatureGeneratorChildren() throws Exception {
        InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestAutomaticallyInsertAggregatedFeatureGeneratorCache.xml");
        Assertions.assertNotNull((Object)generatorDescriptorIn);
        AdaptiveFeatureGenerator featureGenerator = GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
        Assertions.assertInstanceOf(CachedFeatureGenerator.class, (Object)featureGenerator);
        CachedFeatureGenerator cachedFeatureGenerator = (CachedFeatureGenerator)featureGenerator;
        AdaptiveFeatureGenerator afg = cachedFeatureGenerator.getCachedFeatureGenerator();
        Assertions.assertInstanceOf(AggregatedFeatureGenerator.class, (Object)afg);
        AggregatedFeatureGenerator aggregatedFeatureGenerator = (AggregatedFeatureGenerator)afg;
        Assertions.assertEquals((int)3, (int)aggregatedFeatureGenerator.getGenerators().size());
        for (AdaptiveFeatureGenerator afgen : aggregatedFeatureGenerator.getGenerators()) {
            Assertions.assertInstanceOf(OutcomePriorFeatureGenerator.class, (Object)afgen);
        }
    }

    @Test
    void testInsertCachedFeatureGenerator() throws Exception {
        InputStream generatorDescriptorIn = this.getClass().getResourceAsStream("/opennlp/tools/util/featuregen/TestInsertCachedFeatureGenerator.xml");
        Assertions.assertNotNull((Object)generatorDescriptorIn);
        AdaptiveFeatureGenerator featureGenerator = GeneratorFactory.create((InputStream)generatorDescriptorIn, null);
        Assertions.assertInstanceOf(CachedFeatureGenerator.class, (Object)featureGenerator);
        CachedFeatureGenerator cachedFeatureGenerator = (CachedFeatureGenerator)featureGenerator;
        Assertions.assertInstanceOf(AggregatedFeatureGenerator.class, (Object)cachedFeatureGenerator.getCachedFeatureGenerator());
        AggregatedFeatureGenerator aggregatedFeatureGenerator = (AggregatedFeatureGenerator)cachedFeatureGenerator.getCachedFeatureGenerator();
        Assertions.assertEquals((int)3, (int)aggregatedFeatureGenerator.getGenerators().size());
        for (AdaptiveFeatureGenerator afg : aggregatedFeatureGenerator.getGenerators()) {
            Assertions.assertInstanceOf(OutcomePriorFeatureGenerator.class, (Object)afg);
        }
    }

    record TestParametersFeatureGenerator(int ip, float fp, long lp, double dp, boolean bp, String sp) implements AdaptiveFeatureGenerator
    {
        public void createFeatures(List<String> features, String[] tokens, int index, String[] previousOutcomes) {
        }
    }

    static class TestParametersFeatureGeneratorFactory
    extends GeneratorFactory.AbstractXmlFeatureGeneratorFactory {
        public AdaptiveFeatureGenerator create() throws InvalidFormatException {
            return new TestParametersFeatureGenerator(this.getInt("intParam"), this.getFloat("floatParam"), this.getLong("longParam"), this.getDouble("doubleParam"), this.getBool("boolParam"), this.getStr("strParam"));
        }
    }
}

