/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import opennlp.tools.util.featuregen.FeatureGeneratorUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FeatureGeneratorUtilTest {
    @Test
    void test() {
        Assertions.assertEquals((Object)"2d", (Object)FeatureGeneratorUtil.tokenFeature((String)"12"));
        Assertions.assertEquals((Object)"4d", (Object)FeatureGeneratorUtil.tokenFeature((String)"1234"));
        Assertions.assertEquals((Object)"an", (Object)FeatureGeneratorUtil.tokenFeature((String)"abcd234"));
        Assertions.assertEquals((Object)"dd", (Object)FeatureGeneratorUtil.tokenFeature((String)"1234-56"));
        Assertions.assertEquals((Object)"ds", (Object)FeatureGeneratorUtil.tokenFeature((String)"4/6/2017"));
        Assertions.assertEquals((Object)"dc", (Object)FeatureGeneratorUtil.tokenFeature((String)"1,234,567"));
        Assertions.assertEquals((Object)"dp", (Object)FeatureGeneratorUtil.tokenFeature((String)"12.34567"));
        Assertions.assertEquals((Object)"num", (Object)FeatureGeneratorUtil.tokenFeature((String)"123(456)7890"));
        Assertions.assertEquals((Object)"lc", (Object)FeatureGeneratorUtil.tokenFeature((String)"opennlp"));
        Assertions.assertEquals((Object)"sc", (Object)FeatureGeneratorUtil.tokenFeature((String)"O"));
        Assertions.assertEquals((Object)"ac", (Object)FeatureGeneratorUtil.tokenFeature((String)"OPENNLP"));
        Assertions.assertEquals((Object)"cp", (Object)FeatureGeneratorUtil.tokenFeature((String)"A."));
        Assertions.assertEquals((Object)"ic", (Object)FeatureGeneratorUtil.tokenFeature((String)"Mike"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"somethingStupid"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)","));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"."));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"?"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"!"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"#"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"%"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"&"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00a7"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"^"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00b0"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"("));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)")"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"/"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"\\"));
    }

    @Test
    void testGerman() {
        Assertions.assertEquals((Object)"ic", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00c4nne"));
        Assertions.assertEquals((Object)"ic", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00d6zlem"));
        Assertions.assertEquals((Object)"ic", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00dcmit"));
        Assertions.assertEquals((Object)"cp", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00c4."));
        Assertions.assertEquals((Object)"cp", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00d6."));
        Assertions.assertEquals((Object)"cp", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00dc."));
        Assertions.assertEquals((Object)"sc", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u00dc"));
    }

    @Test
    void testJapanese() {
        Assertions.assertEquals((Object)"jah", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u305d\u3046\u3044\u3048\u3070"));
        Assertions.assertEquals((Object)"jah", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u304a\u30fc\u3077\u3093\u30fb\u305d\u301c\u3059\u30fb\u305d\u3075\u3068\u3046\u3047\u3042"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u3042\u3071\u3063\u3061\u30fb\u305d\u3075\u3068\u3046\u3047\u3042\u8ca1\u56e3"));
        Assertions.assertEquals((Object)"jak", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u30b8\u30e3\u30d1\u30f3"));
        Assertions.assertEquals((Object)"jak", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u30aa\u30fc\u30d7\u30f3\u30fb\u30bd\u301c\u30b9\u30fb\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2"));
        Assertions.assertEquals((Object)"other", (Object)FeatureGeneratorUtil.tokenFeature((String)"\u30a2\u30d1\u30c3\u30c1\u30fb\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u8ca1\u56e3"));
    }
}

