/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.CharacterNgramFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CharacterNgramFeatureGeneratorTest {
    private List<String> features;
    private static final String[] TEST_SENTENCE = new String[]{"This", "is", "an", "example", "sentence"};

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testDefault() {
        int testTokenIndex = 3;
        CharacterNgramFeatureGenerator generator = new CharacterNgramFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 3, null);
        CharacterNgramFeatureGeneratorTest.assertContainsNg(this.features, "ex", "exa", "exam", "examp", "xa", "xam", "xamp", "xampl", "am", "amp", "ampl", "ample", "mp", "mpl", "mple", "pl", "ple", "le");
    }

    private static void assertContainsNg(List<String> features, String ... elements) {
        Assertions.assertEquals((int)elements.length, (int)features.size());
        for (String e : elements) {
            Assertions.assertTrue((boolean)features.contains("ng=" + e));
        }
    }
}

