/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.IdentityFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CachedFeatureGeneratorTest {
    private final AdaptiveFeatureGenerator identityGenerator = new IdentityFeatureGenerator();
    private String[] testSentence1;
    private String[] testSentence2;
    private List<String> features;

    @BeforeEach
    void setUp() {
        this.testSentence1 = new String[]{"a1", "b1", "c1", "d1"};
        this.testSentence2 = new String[]{"a2", "b2", "c2", "d2"};
        this.features = new ArrayList<String>();
    }

    @Test
    void testCachingOfSentence() {
        CachedFeatureGenerator generator = new CachedFeatureGenerator(this.identityGenerator);
        int testIndex = 0;
        generator.createFeatures(this.features, this.testSentence1, testIndex, null);
        Assertions.assertEquals((long)1L, (long)generator.getNumberOfCacheMisses());
        Assertions.assertEquals((long)0L, (long)generator.getNumberOfCacheHits());
        Assertions.assertTrue((boolean)this.features.contains(this.testSentence1[testIndex]));
        this.features.clear();
        String expectedToken = this.testSentence1[testIndex];
        this.testSentence1[testIndex] = null;
        generator.createFeatures(this.features, this.testSentence1, testIndex, null);
        Assertions.assertEquals((long)1L, (long)generator.getNumberOfCacheMisses());
        Assertions.assertEquals((long)1L, (long)generator.getNumberOfCacheHits());
        Assertions.assertTrue((boolean)this.features.contains(expectedToken));
        Assertions.assertEquals((int)1, (int)this.features.size());
        this.features.clear();
        int testIndex2 = testIndex + 1;
        generator.createFeatures(this.features, this.testSentence1, testIndex2, null);
        Assertions.assertEquals((long)2L, (long)generator.getNumberOfCacheMisses());
        Assertions.assertEquals((long)1L, (long)generator.getNumberOfCacheHits());
        Assertions.assertTrue((boolean)this.features.contains(this.testSentence1[testIndex2]));
        this.features.clear();
        generator.createFeatures(this.features, this.testSentence1, testIndex, null);
        Assertions.assertTrue((boolean)this.features.contains(expectedToken));
    }

    @Test
    void testCacheClearAfterSentenceChange() {
        CachedFeatureGenerator generator = new CachedFeatureGenerator(this.identityGenerator);
        int testIndex = 0;
        generator.createFeatures(this.features, this.testSentence1, testIndex, null);
        this.features.clear();
        generator.createFeatures(this.features, this.testSentence2, testIndex, null);
        Assertions.assertEquals((long)2L, (long)generator.getNumberOfCacheMisses());
        Assertions.assertEquals((long)0L, (long)generator.getNumberOfCacheHits());
        Assertions.assertTrue((boolean)this.features.contains(this.testSentence2[testIndex]));
        Assertions.assertEquals((int)1, (int)this.features.size());
        this.features.clear();
        String expectedToken = this.testSentence2[testIndex];
        this.testSentence2[testIndex] = null;
        generator.createFeatures(this.features, this.testSentence2, testIndex, null);
        Assertions.assertTrue((boolean)this.features.contains(expectedToken));
        Assertions.assertEquals((int)1, (int)this.features.size());
    }
}

