/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.BrownBigramFeatureGenerator;
import opennlp.tools.util.featuregen.BrownCluster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BrownBigramFeatureGeneratorTest {
    private AdaptiveFeatureGenerator generator;

    @BeforeEach
    void setup() throws IOException {
        ResourceAsStreamFactory stream = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/formats/brown-cluster.txt");
        BrownCluster brownCluster = new BrownCluster(stream.createInputStream());
        this.generator = new BrownBigramFeatureGenerator(brownCluster);
    }

    @Test
    void createFeaturesTest() {
        String[] tokens = new String[]{"he", "went", "with", "you"};
        ArrayList features = new ArrayList();
        this.generator.createFeatures(features, tokens, 3, null);
        Assertions.assertEquals((int)2, (int)features.size());
        Assertions.assertTrue((boolean)features.contains("pbrowncluster,browncluster=0101,0010"));
        Assertions.assertTrue((boolean)features.contains("pbrowncluster,browncluster=01010,00101"));
    }

    @Test
    void createFeaturesSuccessiveTokensTest() {
        String[] testSentence = new String[]{"he", "went", "with", "you", "in", "town"};
        ArrayList features = new ArrayList();
        this.generator.createFeatures(features, testSentence, 3, null);
        Assertions.assertEquals((int)3, (int)features.size());
        Assertions.assertTrue((boolean)features.contains("pbrowncluster,browncluster=0101,0010"));
        Assertions.assertTrue((boolean)features.contains("pbrowncluster,browncluster=01010,00101"));
        Assertions.assertTrue((boolean)features.contains("browncluster,nbrowncluster=0010,0000"));
    }

    @Test
    void noFeaturesTest() {
        String[] testSentence = new String[]{"he", "went", "with", "you"};
        ArrayList features = new ArrayList();
        this.generator.createFeatures(features, testSentence, 0, null);
        Assertions.assertEquals((int)0, (int)features.size());
    }
}

