/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.util.featuregen.BigramNameFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BigramNameFeatureGeneratorTest {
    private List<String> features;
    private static final String[] TEST_SENTENCE = new String[]{"This", "is", "an", "example", "sentence"};

    @BeforeEach
    void setUp() {
        this.features = new ArrayList<String>();
    }

    @Test
    void testBegin() {
        boolean testTokenIndex = false;
        BigramNameFeatureGenerator generator = new BigramNameFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 0, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"w,nw=This,is", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"wc,nc=ic,lc", (Object)this.features.get(1));
    }

    @Test
    void testMiddle() {
        int testTokenIndex = 2;
        BigramNameFeatureGenerator generator = new BigramNameFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 2, null);
        Assertions.assertEquals((int)4, (int)this.features.size());
        Assertions.assertEquals((Object)"pw,w=is,an", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"pwc,wc=lc,lc", (Object)this.features.get(1));
        Assertions.assertEquals((Object)"w,nw=an,example", (Object)this.features.get(2));
        Assertions.assertEquals((Object)"wc,nc=lc,lc", (Object)this.features.get(3));
    }

    @Test
    void testEnd() {
        int testTokenIndex = 4;
        BigramNameFeatureGenerator generator = new BigramNameFeatureGenerator();
        generator.createFeatures(this.features, TEST_SENTENCE, 4, null);
        Assertions.assertEquals((int)2, (int)this.features.size());
        Assertions.assertEquals((Object)"pw,w=example,sentence", (Object)this.features.get(0));
        Assertions.assertEquals((Object)"pwc,wc=lc,lc", (Object)this.features.get(1));
    }

    @Test
    void testShort() {
        String[] shortSentence = new String[]{"word"};
        boolean testTokenIndex = false;
        BigramNameFeatureGenerator generator = new BigramNameFeatureGenerator();
        generator.createFeatures(this.features, shortSentence, 0, null);
        Assertions.assertEquals((int)0, (int)this.features.size());
    }
}

