/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

import opennlp.tools.util.Span;
import opennlp.tools.util.eval.FMeasure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FMeasureTest {
    private static final double DELTA = 1.0E-9;
    private final Span[] gold = new Span[]{new Span(8, 9), new Span(9, 10), new Span(10, 12), new Span(13, 14), new Span(14, 15), new Span(15, 16)};
    private final Span[] predicted = new Span[]{new Span(14, 15), new Span(15, 16), new Span(100, 120), new Span(210, 220), new Span(220, 230)};
    private final Span[] predictedCompletelyDistinct = new Span[]{new Span(100, 120), new Span(210, 220), new Span(211, 220), new Span(212, 220), new Span(220, 230)};
    private final Span[] goldToMerge = new Span[]{new Span(8, 9), new Span(9, 10), new Span(11, 11), new Span(13, 14), new Span(14, 15), new Span(15, 16), new Span(18, 19)};
    private final Span[] predictedToMerge = new Span[]{new Span(8, 9), new Span(14, 15), new Span(15, 16), new Span(100, 120), new Span(210, 220), new Span(220, 230)};

    @Test
    public void testCountTruePositives() {
        Assertions.assertEquals((int)0, (int)FMeasure.countTruePositives((Object[])new Object[0], (Object[])new Object[0]));
        Assertions.assertEquals((int)this.gold.length, (int)FMeasure.countTruePositives((Object[])this.gold, (Object[])this.gold));
        Assertions.assertEquals((int)0, (int)FMeasure.countTruePositives((Object[])this.gold, (Object[])this.predictedCompletelyDistinct));
        Assertions.assertEquals((int)2, (int)FMeasure.countTruePositives((Object[])this.gold, (Object[])this.predicted));
    }

    @Test
    public void testPrecision() {
        Assertions.assertEquals((double)1.0, (double)FMeasure.precision((Object[])this.gold, (Object[])this.gold), (double)1.0E-9);
        Assertions.assertEquals((double)0.0, (double)FMeasure.precision((Object[])this.gold, (Object[])this.predictedCompletelyDistinct), (double)1.0E-9);
        Assertions.assertEquals((double)Double.NaN, (double)FMeasure.precision((Object[])this.gold, (Object[])new Object[0]), (double)1.0E-9);
        Assertions.assertEquals((double)0.0, (double)FMeasure.precision((Object[])new Object[0], (Object[])this.gold), (double)1.0E-9);
        Assertions.assertEquals((double)(2.0 / (double)this.predicted.length), (double)FMeasure.precision((Object[])this.gold, (Object[])this.predicted), (double)1.0E-9);
    }

    @Test
    public void testRecall() {
        Assertions.assertEquals((double)1.0, (double)FMeasure.recall((Object[])this.gold, (Object[])this.gold), (double)1.0E-9);
        Assertions.assertEquals((double)0.0, (double)FMeasure.recall((Object[])this.gold, (Object[])this.predictedCompletelyDistinct), (double)1.0E-9);
        Assertions.assertEquals((double)0.0, (double)FMeasure.recall((Object[])this.gold, (Object[])new Object[0]), (double)1.0E-9);
        Assertions.assertEquals((double)Double.NaN, (double)FMeasure.recall((Object[])new Object[0], (Object[])this.gold), (double)1.0E-9);
        Assertions.assertEquals((double)(2.0 / (double)this.gold.length), (double)FMeasure.recall((Object[])this.gold, (Object[])this.predicted), (double)1.0E-9);
    }

    @Test
    public void testEmpty() {
        FMeasure fm = new FMeasure();
        Assertions.assertEquals((double)-1.0, (double)fm.getFMeasure(), (double)1.0E-9);
        Assertions.assertEquals((double)0.0, (double)fm.getRecallScore(), (double)1.0E-9);
        Assertions.assertEquals((double)0.0, (double)fm.getPrecisionScore(), (double)1.0E-9);
    }

    @Test
    public void testPerfect() {
        FMeasure fm = new FMeasure();
        fm.updateScores((Object[])this.gold, (Object[])this.gold);
        Assertions.assertEquals((double)1.0, (double)fm.getFMeasure(), (double)1.0E-9);
        Assertions.assertEquals((double)1.0, (double)fm.getRecallScore(), (double)1.0E-9);
        Assertions.assertEquals((double)1.0, (double)fm.getPrecisionScore(), (double)1.0E-9);
    }

    @Test
    public void testMerge() {
        FMeasure fm = new FMeasure();
        fm.updateScores((Object[])this.gold, (Object[])this.predicted);
        fm.updateScores((Object[])this.goldToMerge, (Object[])this.predictedToMerge);
        FMeasure fmMerge = new FMeasure();
        fmMerge.updateScores((Object[])this.gold, (Object[])this.predicted);
        FMeasure toMerge = new FMeasure();
        toMerge.updateScores((Object[])this.goldToMerge, (Object[])this.predictedToMerge);
        fmMerge.mergeInto(toMerge);
        double selected1 = this.predicted.length;
        double target1 = this.gold.length;
        double tp1 = FMeasure.countTruePositives((Object[])this.gold, (Object[])this.predicted);
        double selected2 = this.predictedToMerge.length;
        double target2 = this.goldToMerge.length;
        double tp2 = FMeasure.countTruePositives((Object[])this.goldToMerge, (Object[])this.predictedToMerge);
        Assertions.assertEquals((double)((tp1 + tp2) / (target1 + target2)), (double)fm.getRecallScore(), (double)1.0E-9);
        Assertions.assertEquals((double)((tp1 + tp2) / (selected1 + selected2)), (double)fm.getPrecisionScore(), (double)1.0E-9);
        Assertions.assertEquals((double)fm.getRecallScore(), (double)fmMerge.getRecallScore(), (double)1.0E-9);
        Assertions.assertEquals((double)fm.getPrecisionScore(), (double)fmMerge.getPrecisionScore(), (double)1.0E-9);
    }
}

