/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CrossValidationPartitionerTest {
    @Test
    void testEmptyDataSet() throws IOException {
        Set emptyCollection = Collections.emptySet();
        CrossValidationPartitioner partitioner = new CrossValidationPartitioner(emptyCollection, 2);
        Assertions.assertTrue((boolean)partitioner.hasNext());
        Assertions.assertNull((Object)partitioner.next().read());
        Assertions.assertTrue((boolean)partitioner.hasNext());
        Assertions.assertNull((Object)partitioner.next().read());
        Assertions.assertFalse((boolean)partitioner.hasNext());
        try {
            partitioner.next();
            Assertions.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    void test3FoldCV() throws IOException {
        LinkedList<String> data = new LinkedList<String>();
        data.add("01");
        data.add("02");
        data.add("03");
        data.add("04");
        data.add("05");
        data.add("06");
        data.add("07");
        data.add("08");
        data.add("09");
        data.add("10");
        CrossValidationPartitioner partitioner = new CrossValidationPartitioner(data, 3);
        Assertions.assertTrue((boolean)partitioner.hasNext());
        CrossValidationPartitioner.TrainingSampleStream firstTraining = partitioner.next();
        Assertions.assertEquals((Object)"02", (Object)firstTraining.read());
        Assertions.assertEquals((Object)"03", (Object)firstTraining.read());
        Assertions.assertEquals((Object)"05", (Object)firstTraining.read());
        Assertions.assertEquals((Object)"06", (Object)firstTraining.read());
        Assertions.assertEquals((Object)"08", (Object)firstTraining.read());
        Assertions.assertEquals((Object)"09", (Object)firstTraining.read());
        Assertions.assertNull((Object)firstTraining.read());
        ObjectStream firstTest = firstTraining.getTestSampleStream();
        Assertions.assertEquals((Object)"01", (Object)firstTest.read());
        Assertions.assertEquals((Object)"04", (Object)firstTest.read());
        Assertions.assertEquals((Object)"07", (Object)firstTest.read());
        Assertions.assertEquals((Object)"10", (Object)firstTest.read());
        Assertions.assertNull((Object)firstTest.read());
        Assertions.assertTrue((boolean)partitioner.hasNext());
        CrossValidationPartitioner.TrainingSampleStream secondTraining = partitioner.next();
        Assertions.assertEquals((Object)"01", (Object)secondTraining.read());
        Assertions.assertEquals((Object)"03", (Object)secondTraining.read());
        Assertions.assertEquals((Object)"04", (Object)secondTraining.read());
        Assertions.assertEquals((Object)"06", (Object)secondTraining.read());
        Assertions.assertEquals((Object)"07", (Object)secondTraining.read());
        Assertions.assertEquals((Object)"09", (Object)secondTraining.read());
        Assertions.assertEquals((Object)"10", (Object)secondTraining.read());
        Assertions.assertNull((Object)secondTraining.read());
        ObjectStream secondTest = secondTraining.getTestSampleStream();
        Assertions.assertEquals((Object)"02", (Object)secondTest.read());
        Assertions.assertEquals((Object)"05", (Object)secondTest.read());
        Assertions.assertEquals((Object)"08", (Object)secondTest.read());
        Assertions.assertNull((Object)secondTest.read());
        Assertions.assertTrue((boolean)partitioner.hasNext());
        CrossValidationPartitioner.TrainingSampleStream thirdTraining = partitioner.next();
        Assertions.assertEquals((Object)"01", (Object)thirdTraining.read());
        Assertions.assertEquals((Object)"02", (Object)thirdTraining.read());
        Assertions.assertEquals((Object)"04", (Object)thirdTraining.read());
        Assertions.assertEquals((Object)"05", (Object)thirdTraining.read());
        Assertions.assertEquals((Object)"07", (Object)thirdTraining.read());
        Assertions.assertEquals((Object)"08", (Object)thirdTraining.read());
        Assertions.assertEquals((Object)"10", (Object)thirdTraining.read());
        Assertions.assertNull((Object)thirdTraining.read());
        ObjectStream thirdTest = thirdTraining.getTestSampleStream();
        Assertions.assertEquals((Object)"03", (Object)thirdTest.read());
        Assertions.assertEquals((Object)"06", (Object)thirdTest.read());
        Assertions.assertEquals((Object)"09", (Object)thirdTest.read());
        Assertions.assertNull((Object)thirdTest.read());
        Assertions.assertFalse((boolean)partitioner.hasNext());
    }

    @Test
    void testFailSafty() throws IOException {
        LinkedList<String> data = new LinkedList<String>();
        data.add("01");
        data.add("02");
        data.add("03");
        data.add("04");
        CrossValidationPartitioner partitioner = new CrossValidationPartitioner(data, 4);
        CrossValidationPartitioner.TrainingSampleStream firstTraining = partitioner.next();
        Assertions.assertEquals((Object)"02", (Object)firstTraining.read());
        CrossValidationPartitioner.TrainingSampleStream secondTraining = partitioner.next();
        try {
            firstTraining.read();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            firstTraining.getTestSampleStream();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        secondTraining.getTestSampleStream();
        try {
            secondTraining.read();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CrossValidationPartitioner.TrainingSampleStream thirdTraining = partitioner.next();
        ObjectStream thridTest = thirdTraining.getTestSampleStream();
        Assertions.assertTrue((boolean)partitioner.hasNext());
        partitioner.next();
        try {
            thridTest.read();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    void testToString() {
        Set emptyCollection = Collections.emptySet();
        new CrossValidationPartitioner(emptyCollection, 10).toString();
    }
}

