/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import opennlp.tools.util.Version;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VersionTest {
    @Test
    void testParse() {
        Version referenceVersion = Version.currentVersion();
        Assertions.assertEquals((Object)referenceVersion, (Object)Version.parse((String)referenceVersion.toString()));
        Assertions.assertEquals((Object)new Version(1, 5, 2, false), (Object)Version.parse((String)"1.5.2-incubating"));
        Assertions.assertEquals((Object)new Version(1, 5, 2, false), (Object)Version.parse((String)"1.5.2"));
    }

    @Test
    void testParseSnapshot() {
        Assertions.assertEquals((Object)new Version(1, 5, 2, true), (Object)Version.parse((String)"1.5.2-incubating-SNAPSHOT"));
        Assertions.assertEquals((Object)new Version(1, 5, 2, true), (Object)Version.parse((String)"1.5.2-SNAPSHOT"));
    }

    @Test
    void testParseProjectVersionWithRarePatchVersion() {
        Assertions.assertEquals((Object)new Version(2, 5, 6, false), (Object)Version.parse((String)"2.5.6.1"));
    }

    @Test
    void testParseInvalidVersion() {
        try {
            Version.parse((String)"1.5.");
        }
        catch (NumberFormatException e) {
            return;
        }
        Assertions.assertFalse((boolean)false);
    }

    @Test
    void testParseInvalidVersion2() {
        try {
            Version.parse((String)"1.5");
        }
        catch (NumberFormatException e) {
            return;
        }
        Assertions.fail();
    }
}

