/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TrainingParametersTest {
    @Test
    void testConstructors() throws Exception {
        TrainingParameters tp1 = new TrainingParameters(TrainingParametersTest.build("key1=val1,key2=val2,key3=val3"));
        TrainingParameters tp2 = new TrainingParameters((InputStream)new ByteArrayInputStream("key1=val1\nkey2=val2\nkey3=val3\n".getBytes()));
        TrainingParameters tp3 = new TrainingParameters(tp2);
        TrainingParametersTest.assertEquals(tp1, tp2);
        TrainingParametersTest.assertEquals(tp2, tp3);
    }

    @Test
    void testDefault() {
        TrainingParameters tr = TrainingParameters.defaultParams();
        Assertions.assertEquals((int)4, (int)tr.getObjectSettings().size());
        Assertions.assertEquals((Object)"MAXENT", (Object)tr.algorithm());
        Assertions.assertEquals((Object)"Event", (Object)tr.getStringParameter("TrainerType", "v11"));
        Assertions.assertEquals((int)100, (int)tr.getIntParameter("Iterations", 200));
        Assertions.assertEquals((int)5, (int)tr.getIntParameter("Cutoff", 200));
    }

    @Test
    public void testSetParamsWithCLIParams() {
        String[] args = new String[]{"-model", "en-token-test.bin", "-alphaNumOpt", "isAlphaNumOpt", "-lang", "en", "-data", "en-token.train", "-encoding", "UTF-8", "-cutoff", "10", "-iterations", "50"};
        TrainingParameters tr = TrainingParameters.setParams((String[])args);
        Assertions.assertEquals((Object)"MAXENT", (Object)tr.algorithm());
        Assertions.assertEquals((int)50, (int)tr.getIntParameter("Iterations", 100));
        Assertions.assertEquals((int)10, (int)tr.getIntParameter("Cutoff", 5));
    }

    @Test
    public void testSetParamsWithoutCLIParams() {
        String[] args = new String[]{"-model", "en-token-test.bin", "-alphaNumOpt", "isAlphaNumOpt", "-lang", "en", "-data", "en-token.train", "-encoding", "UTF-8"};
        TrainingParameters tr = TrainingParameters.setParams((String[])args);
        Assertions.assertEquals((Object)"MAXENT", (Object)tr.algorithm());
        Assertions.assertEquals((int)100, (int)tr.getIntParameter("Iterations", 100));
        Assertions.assertEquals((int)5, (int)tr.getIntParameter("Cutoff", 5));
    }

    @Test
    public void testSetParamsWithoutCutoffCLIParams() {
        String[] args = new String[]{"-model", "en-token-test.bin", "-alphaNumOpt", "isAlphaNumOpt", "-lang", "en", "-data", "en-token.train", "-encoding", "UTF-8", "-iterations", "50"};
        TrainingParameters tr = TrainingParameters.setParams((String[])args);
        Assertions.assertEquals((Object)"MAXENT", (Object)tr.algorithm());
        Assertions.assertEquals((int)50, (int)tr.getIntParameter("Iterations", 100));
        Assertions.assertEquals((int)5, (int)tr.getIntParameter("Cutoff", 5));
    }

    @Test
    public void testSetParamsWithoutIterationsCLIParams() {
        String[] args = new String[]{"-model", "en-token-test.bin", "-alphaNumOpt", "isAlphaNumOpt", "-lang", "en", "-data", "en-token.train", "-encoding", "UTF-8", "-cutoff", "10"};
        TrainingParameters tr = TrainingParameters.setParams((String[])args);
        Assertions.assertEquals((Object)"MAXENT", (Object)tr.algorithm());
        Assertions.assertEquals((int)100, (int)tr.getIntParameter("Iterations", 100));
        Assertions.assertEquals((int)10, (int)tr.getIntParameter("Cutoff", 5));
    }

    @Test
    void testGetAlgorithm() {
        TrainingParameters tp = TrainingParametersTest.build("Algorithm=Perceptron,n1.Algorithm=SVM");
        Assertions.assertEquals((Object)"Perceptron", (Object)tp.algorithm());
        Assertions.assertEquals((Object)"SVM", (Object)tp.algorithm("n1"));
    }

    @Test
    void testGetAlgorithmCaseInsensitive() {
        TrainingParameters tp = TrainingParametersTest.build("ALGORITHM=Perceptron,n1.Algorithm=SVM");
        Assertions.assertEquals((Object)"Perceptron", (Object)tp.algorithm());
        Assertions.assertEquals((Object)"SVM", (Object)tp.algorithm("n1"));
    }

    @Test
    void testGetSettings() {
        TrainingParameters tp = TrainingParametersTest.build("k1=v1,n1.k2=v2,n2.k3=v3,n1.k4=v4");
        TrainingParametersTest.assertEquals(TrainingParametersTest.buildMap("k1=v1"), tp.getObjectSettings());
        TrainingParametersTest.assertEquals(TrainingParametersTest.buildMap("k2=v2,k4=v4"), tp.getObjectSettings("n1"));
        TrainingParametersTest.assertEquals(TrainingParametersTest.buildMap("k3=v3"), tp.getObjectSettings("n2"));
        Assertions.assertTrue((boolean)tp.getObjectSettings("n3").isEmpty());
    }

    @Test
    void testGetParameters() {
        TrainingParameters tp = TrainingParametersTest.build("k1=v1,n1.k2=v2,n2.k3=v3,n1.k4=v4");
        TrainingParametersTest.assertEquals(TrainingParametersTest.build("k1=v1"), tp.getParameters(null));
        TrainingParametersTest.assertEquals(TrainingParametersTest.build("k2=v2,k4=v4"), tp.getParameters("n1"));
        TrainingParametersTest.assertEquals(TrainingParametersTest.build("k3=v3"), tp.getParameters("n2"));
        Assertions.assertTrue((boolean)tp.getParameters("n3").getObjectSettings().isEmpty());
    }

    @Test
    void testPutGet() {
        TrainingParameters tp = TrainingParametersTest.build("k1=v1,int.k2=123,str.k2=v3,str.k3=v4,boolean.k4=false,double.k5=123.45,k21=234.5");
        Assertions.assertEquals((Object)"v1", (Object)tp.getStringParameter("k1", "def"));
        Assertions.assertEquals((Object)"def", (Object)tp.getStringParameter("k2", "def"));
        Assertions.assertEquals((Object)"v3", (Object)tp.getStringParameter("str", "k2", "def"));
        Assertions.assertEquals((Object)"def", (Object)tp.getStringParameter("str", "k4", "def"));
        Assertions.assertEquals((int)-100, (int)tp.getIntParameter("k11", -100));
        tp.put("k11", 234);
        Assertions.assertEquals((int)234, (int)tp.getIntParameter("k11", -100));
        Assertions.assertEquals((int)123, (int)tp.getIntParameter("int", "k2", -100));
        Assertions.assertEquals((int)-100, (int)tp.getIntParameter("int", "k4", -100));
        Assertions.assertEquals((double)0.001, (double)tp.getDoubleParameter("k21", -100.0), (double)234.5);
        tp.put("k21", 345.6);
        Assertions.assertEquals((double)0.001, (double)tp.getDoubleParameter("k21", -100.0), (double)345.6);
        tp.putIfAbsent("k21", 456.7);
        Assertions.assertEquals((double)0.001, (double)tp.getDoubleParameter("k21", -100.0), (double)345.6);
        Assertions.assertEquals((double)0.001, (double)tp.getDoubleParameter("double", "k5", -100.0), (double)123.45);
        Assertions.assertTrue((boolean)tp.getBooleanParameter("k31", true));
        tp.put("k31", false);
        Assertions.assertFalse((boolean)tp.getBooleanParameter("k31", true));
        Assertions.assertFalse((boolean)tp.getBooleanParameter("boolean", "k4", true));
    }

    private static Map<String, Object> buildMap(String str) {
        String[] pairs = str.split(",");
        HashMap<String, Object> map = new HashMap<String, Object>(pairs.length);
        for (String pair : pairs) {
            String[] keyValue = pair.split("=");
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    private static TrainingParameters build(String str) {
        return new TrainingParameters(TrainingParametersTest.buildMap(str));
    }

    private static void assertEquals(Map<String, Object> map1, Map<String, Object> map2) {
        Assertions.assertNotNull(map1);
        Assertions.assertNotNull(map2);
        Assertions.assertEquals((int)map1.size(), (int)map2.size());
        for (String key : map1.keySet()) {
            Assertions.assertEquals((Object)map1.get(key), (Object)map2.get(key));
        }
    }

    private static void assertEquals(Map<String, Object> map, TrainingParameters actual) {
        Assertions.assertNotNull((Object)actual);
        TrainingParametersTest.assertEquals(map, actual.getObjectSettings());
    }

    private static void assertEquals(TrainingParameters expected, TrainingParameters actual) {
        if (expected == null) {
            Assertions.assertNull((Object)actual);
        } else {
            TrainingParametersTest.assertEquals((Map<String, Object>)expected.getObjectSettings(), actual);
        }
    }
}

