/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import opennlp.tools.util.StringUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilTest {
    @Test
    void testNoBreakSpace() {
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((int)160));
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((int)8199));
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((int)8239));
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((char)'\u00a0'));
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((char)'\u2007'));
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((char)'\u202f'));
    }

    @Test
    void testToLowerCase() {
        Assertions.assertEquals((Object)"test", (Object)StringUtil.toLowerCase((CharSequence)"TEST"));
        Assertions.assertEquals((Object)"simple", (Object)StringUtil.toLowerCase((CharSequence)"SIMPLE"));
    }

    @Test
    void testToUpperCase() {
        Assertions.assertEquals((Object)"TEST", (Object)StringUtil.toUpperCase((CharSequence)"test"));
        Assertions.assertEquals((Object)"SIMPLE", (Object)StringUtil.toUpperCase((CharSequence)"simple"));
    }

    @Test
    void testIsEmpty() {
        Assertions.assertTrue((boolean)StringUtil.isEmpty((CharSequence)""));
        Assertions.assertFalse((boolean)StringUtil.isEmpty((CharSequence)"a"));
    }

    @Test
    void testIsEmptyWithNullString() {
        Assertions.assertThrows(NullPointerException.class, () -> StringUtil.isEmpty(null));
    }

    @Test
    void testLowercaseBeyondBMP() {
        int[] codePoints = new int[]{65, 66578, 67};
        int[] expectedCodePoints = new int[]{97, 66618, 99};
        String input = new String(codePoints, 0, codePoints.length);
        String lc = StringUtil.toLowerCase((CharSequence)input);
        Assertions.assertArrayEquals((int[])expectedCodePoints, (int[])lc.codePoints().toArray());
    }
}

