/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Iterator;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringListTest {
    @Test
    void testIntern() {
        StringList l1 = new StringList("a");
        StringList l2 = new StringList(new String[]{"a", "b"});
        Assertions.assertSame((Object)l1.getToken(0), (Object)l2.getToken(0));
    }

    @Test
    void testGetToken() {
        StringList l = new StringList(new String[]{"a", "b"});
        Assertions.assertEquals((int)2, (int)l.size());
        Assertions.assertEquals((Object)"a", (Object)l.getToken(0));
        Assertions.assertEquals((Object)"b", (Object)l.getToken(1));
    }

    @Test
    void testIterator() {
        StringList l = new StringList("a");
        Iterator it = l.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"a", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        l = new StringList(new String[]{"a", "b", "c"});
        it = l.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"a", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"b", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"c", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void testCompareToIgnoreCase() {
        Assertions.assertTrue((boolean)new StringList(new String[]{"a", "b"}).compareToIgnoreCase(new StringList(new String[]{"A", "B"})));
    }

    @Test
    void testEquals() {
        Assertions.assertEquals((Object)new StringList(new String[]{"a", "b"}), (Object)new StringList(new String[]{"a", "b"}));
        Assertions.assertNotEquals((Object)new StringList(new String[]{"a", "b"}), (Object)new StringList(new String[]{"A", "B"}));
    }

    @Test
    void testHashCode() {
        Assertions.assertEquals((int)new StringList(new String[]{"a", "b"}).hashCode(), (int)new StringList(new String[]{"a", "b"}).hashCode());
        Assertions.assertNotEquals((int)new StringList(new String[]{"a", "b"}).hashCode(), (int)new StringList(new String[]{"a", "c"}).hashCode());
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"[a]", (Object)new StringList("a").toString());
        Assertions.assertEquals((Object)"[a,b]", (Object)new StringList(new String[]{"a", "b"}).toString());
    }
}

