/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SpanTest {
    @Test
    void testGetStart() {
        Assertions.assertEquals((int)5, (int)new Span(5, 6).getStart());
    }

    @Test
    void testGetEnd() {
        Assertions.assertEquals((int)6, (int)new Span(5, 6).getEnd());
    }

    @Test
    void testLength() {
        Assertions.assertEquals((int)11, (int)new Span(10, 21).length());
    }

    @Test
    void testContains() {
        Span a = new Span(500, 900);
        Span b = new Span(520, 600);
        Assertions.assertTrue((boolean)a.contains(b));
    }

    @Test
    void testContainsWithEqual() {
        Span a = new Span(500, 900);
        Assertions.assertTrue((boolean)a.contains(a));
    }

    @Test
    void testContainsWithLowerIntersect() {
        Span a = new Span(500, 900);
        Span b = new Span(450, 1000);
        Assertions.assertFalse((boolean)a.contains(b));
    }

    @Test
    void testContainsWithHigherIntersect() {
        Span a = new Span(500, 900);
        Span b = new Span(500, 1000);
        Assertions.assertFalse((boolean)a.contains(b));
    }

    @Test
    void testContainsInt() {
        Span a = new Span(10, 300);
        Assertions.assertFalse((boolean)a.contains(9));
        Assertions.assertTrue((boolean)a.contains(10));
        Assertions.assertTrue((boolean)a.contains(200));
        Assertions.assertTrue((boolean)a.contains(299));
        Assertions.assertFalse((boolean)a.contains(300));
    }

    @Test
    void testStartsWith() {
        Span a = new Span(10, 50);
        Span b = new Span(10, 12);
        Assertions.assertTrue((boolean)a.startsWith(a));
        Assertions.assertTrue((boolean)a.startsWith(b));
        Assertions.assertFalse((boolean)b.startsWith(a));
    }

    @Test
    void testIntersects() {
        Span a = new Span(10, 50);
        Span b = new Span(40, 100);
        Assertions.assertTrue((boolean)a.intersects(b));
        Assertions.assertTrue((boolean)b.intersects(a));
        Span c = new Span(10, 20);
        Span d = new Span(40, 50);
        Assertions.assertFalse((boolean)c.intersects(d));
        Assertions.assertFalse((boolean)d.intersects(c));
        Assertions.assertTrue((boolean)b.intersects(d));
    }

    @Test
    void testCrosses() {
        Span a = new Span(10, 50);
        Span b = new Span(40, 100);
        Assertions.assertTrue((boolean)a.crosses(b));
        Assertions.assertTrue((boolean)b.crosses(a));
        Span c = new Span(10, 20);
        Span d = new Span(40, 50);
        Assertions.assertFalse((boolean)c.crosses(d));
        Assertions.assertFalse((boolean)d.crosses(c));
        Assertions.assertFalse((boolean)b.crosses(d));
    }

    @Test
    void testCompareToLower() {
        Span a = new Span(100, 1000);
        Span b = new Span(10, 50);
        Assertions.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testCompareToHigher() {
        Span a = new Span(100, 200);
        Span b = new Span(300, 400);
        Assertions.assertTrue((a.compareTo(b) < 0 ? 1 : 0) != 0);
    }

    @Test
    void testCompareToEquals() {
        Span a = new Span(30, 1000);
        Span b = new Span(30, 1000);
        Assertions.assertEquals((int)0, (int)a.compareTo(b));
    }

    @Test
    void testCompareToEqualsSameType() {
        Span a = new Span(30, 1000, "a");
        Span b = new Span(30, 1000, "a");
        Assertions.assertEquals((int)0, (int)a.compareTo(b));
    }

    @Test
    void testCompareToEqualsDiffType1() {
        Span a = new Span(30, 1000, "a");
        Span b = new Span(30, 1000, "b");
        Assertions.assertEquals((int)-1, (int)a.compareTo(b));
    }

    @Test
    void testCompareToEqualsDiffType2() {
        Span a = new Span(30, 1000, "b");
        Span b = new Span(30, 1000, "a");
        Assertions.assertEquals((int)1, (int)a.compareTo(b));
    }

    @Test
    void testCompareToEqualsNullType1() {
        Span a = new Span(30, 1000);
        Span b = new Span(30, 1000, "b");
        Assertions.assertEquals((int)1, (int)a.compareTo(b));
    }

    @Test
    void testCompareToEqualsNullType2() {
        Span a = new Span(30, 1000, "b");
        Span b = new Span(30, 1000);
        Assertions.assertEquals((int)-1, (int)a.compareTo(b));
    }

    @Test
    void testhHashCode() {
        Assertions.assertEquals((Object)new Span(10, 11), (Object)new Span(10, 11));
    }

    @Test
    void testEqualsWithNull() {
        Span a = new Span(0, 0);
        Assertions.assertNotNull((Object)a);
    }

    @Test
    void testEquals() {
        Span a1 = new Span(100, 1000, "test");
        Span a2 = new Span(100, 1000, "test");
        Assertions.assertEquals((Object)a1, (Object)a2);
        Span b1 = new Span(100, 100, "test");
        Assertions.assertNotEquals((Object)a1, (Object)b1);
        Span c1 = new Span(100, 1000, "Test");
        Assertions.assertNotEquals((Object)a1, (Object)c1);
        Span d1 = new Span(100, 1000);
        Assertions.assertNotEquals((Object)d1, (Object)a1);
        Assertions.assertNotEquals((Object)a1, (Object)d1);
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"[50..100)", (Object)new Span(50, 100).toString());
        Assertions.assertEquals((Object)"[50..100) myType", (Object)new Span(50, 100, "myType").toString());
    }

    @Test
    void testTrim() {
        String string1 = "  12 34  ";
        Span span1 = new Span(0, string1.length());
        Assertions.assertEquals((Object)"12 34", (Object)span1.trim((CharSequence)string1).getCoveredText((CharSequence)string1));
    }

    @Test
    void testTrimWhitespaceSpan() {
        String string1 = "              ";
        Span span1 = new Span(0, string1.length());
        Assertions.assertEquals((Object)"", (Object)span1.trim((CharSequence)string1).getCoveredText((CharSequence)string1));
    }

    @Test
    void testTooSmallStart() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Span(-1, 100));
    }

    @Test
    void testTooSmallEnd() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Span(50, -1));
    }

    @Test
    void testStartLargerThanEnd() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Span(100, 50));
    }
}

